package org.ferris.journal.gui.view.combobox;

import java.awt.Color;
import java.util.List;

import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;

import org.ferris.constraint.Check;
import org.ferris.constraint.Constraint;

public abstract class KAbstractComboBox extends JComboBox 
{
	private static final long serialVersionUID = -6091951647496943081L;

	private Color originalBackgroundColor;
	
	public KAbstractComboBox(ComboBoxModel m) {
		super(m);		
		originalBackgroundColor = getBackground();
	}
	
	public abstract Constraint<Object> getConstraint(); 
	
	public abstract String getExplaination(Check check);
	
	public KAbstractComboBox validate(List<String> explainations) 
	{
		setBackground(originalBackgroundColor);
		
		Check check 
			= getConstraint().check(getSelectedItem());
		
		if (check != null) {
			setBackground(Color.red);
			explainations.add(getExplaination(check));
		}
		
		return this;
	}
	
	public Color getOriginalBackgroundColor() {
		return originalBackgroundColor;
	}
}
