package org.ferris.journal.gui.view.combobox;

import static org.ferris.journal.gui.i18n.i18n.getString;

import org.ferris.journal.gui.view.list.KJournalListCellRenderer;
import org.ferris.journal.jws.journal.Journal;
import org.ferris.constraint.Check;
import org.ferris.constraint.Constraint;
import org.ferris.constraint.NotNull;

public class KJournalComboBox extends KAbstractComboBox {

	private static final long serialVersionUID = -1916896342701606885L;
	
	private Constraint<Object> constraint;

	public KJournalComboBox(KJournalComboBoxModel m) {
		super(m);
		setRenderer(new KJournalListCellRenderer());
	}
	
	public KJournalComboBoxModel getJournalComboBoxModel() {
		return (KJournalComboBoxModel)super.getModel();
	}

	@Override
	public Constraint<Object> getConstraint() 
	{
		if (constraint == null) {
			constraint = new NotNull<Object>();
		}
		return constraint;
	}

	@Override
	public String getExplaination(Check check) 
	{
		if (check.equals(Check.IsNull)) {
			return getString("entry.journal.malformed.missing");
		}		
		else {
			throw new RuntimeException(
				getString("exception.check.not.recognized", check)
			);
		}
	}

	public Journal getSelectedJournal() {
		return (Journal)getSelectedItem();
	}
}
