package org.ferris.journal.gui.view.combobox;

import java.util.List;

import javax.swing.DefaultComboBoxModel;

import org.apache.log4j.Logger;
import org.ferris.journal.gui.model.JournalObserver;
import org.ferris.journal.gui.model.Model;
import org.ferris.journal.jws.journal.Journal;

public class KJournalComboBoxModel 
extends DefaultComboBoxModel 
implements JournalObserver 
{
	private List<Journal> getJournals() {
		return this.model.getActiveJournals();
	}
	
	private void journalChanged(Journal journal) {
		if (!journal.getIsActive()) {
			log.info("Changed journal is NOT active");
		} else {
			log.info("Changed journal IS active");
			int newSelectedIndex =
				getJournals().indexOf(journal);
			
			fireContentsChanged(this, newSelectedIndex, newSelectedIndex);
		}
	}
	
	
	
	private static final long serialVersionUID = -5067783059004831441L;
	private Logger log = Logger.getLogger(getClass());	
	private Model model;
	
	
	
	public KJournalComboBoxModel(Model model) {
		this.model = model;
	}

	public Object getElementAt(int index) {
		return getJournalAt(index);
	}
	
	public Journal getJournalAt(int index) {
		return getJournals().get(index);
	}

	public int getSize() {
		return getJournals().size();
	}

	
	/////////////////////////////////////////////////////////////////
	//
	// JOURNAL OBSERVER
	//
	/////////////////////////////////////////////////////////////////
	public void deletedJournal(Journal deletedJournal) {
		log.info("ENTER: deletedJournal()");
		fireContentsChanged(this, 0, getJournals().size());
		log.info("EXIT: deletedJournal()");
	}

	public void editJournal(Journal editMe) {
		log.info("ENTER: editJournal()");
		log.info("EXIT: editJournal()");
	}

	public void insertedJournal(Journal newJournal)  {
		log.info("ENTER: insertedJournal()");
		journalChanged(newJournal); 
		log.info("EXIT: insertedJournal()");
	}

	public void newJournal() {
		log.info("ENTER: newJournal()");
		log.info("EXIT: newJournal()");
	}

	public void updatedJournal(Journal updatedJournal) {
		log.info("ENTER: updatedJournal()");
		journalChanged(updatedJournal);
		log.info("EXIT: updatedJournal()");
	}

}
