package org.ferris.journal.gui.view.datepicker;

import java.awt.Color;
import java.util.Date;
import java.util.List;

import org.jdesktop.swingx.JXDatePicker;
import org.ferris.constraint.Check;
import org.ferris.constraint.Constraint;

public abstract class KAbstractDatePicker extends JXDatePicker 
{
	private static final long serialVersionUID = -7002929511454047038L;
	private Color originalBackgroundColor;
	
	public KAbstractDatePicker() {
		super();
		originalBackgroundColor = getEditor().getBackground();
	}
	
	public abstract Constraint<Date> getConstraint(); 
	
	public abstract String getExplaination(Check check); 
	
	public KAbstractDatePicker validate(List<String> explainations) 
	{
		getEditor().setBackground(originalBackgroundColor);
		
		Check check 
			= getConstraint().check(getDate());
		
		if (check != null) {
			getEditor().setBackground(Color.red);
			explainations.add(getExplaination(check));
		}
		
		return this;
	}
	
	public Color getOriginalBackgroundColor() {
		return originalBackgroundColor;
	}
}
