package org.ferris.journal.gui.view.datepicker;

import static org.ferris.journal.gui.i18n.i18n.getString;

import java.util.Date;

import org.ferris.constraint.Check;
import org.ferris.constraint.Constraint;
import org.ferris.constraint.NotNull;

public class KEntryDateDatePicker extends KAbstractDatePicker 
{
	private static final long serialVersionUID = 8796488332957373874L;
	private Constraint<Date> constraint = null;
	
	@Override
	public Constraint<Date> getConstraint() 
	{
		if (constraint == null) {
			constraint = new NotNull<Date>();
		}
		return constraint;
	}

	@Override
	public String getExplaination(Check check) 
	{
		if (check.equals(Check.IsNull)) {
			return getString("entry.date.malformed.missing");
		}		
		else {
			throw new RuntimeException(
				getString("exception.check.not.recognized", check)
			);
		}
	}

}
