package org.ferris.journal.gui.view.frame;

import static org.ferris.journal.gui.i18n.i18n.getString;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.BevelBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

import org.apache.log4j.Logger;
import org.ferris.journal.gui.controller.EntryController;
import org.ferris.journal.gui.model.JournalEntryObserver;
import org.ferris.journal.gui.model.JournalObserver;
import org.ferris.journal.gui.model.Model;
import org.ferris.journal.gui.model.ModelForVisualEditor;
import org.ferris.journal.gui.model.OperationObserver;
import org.ferris.journal.gui.model.ReleaseObserver;
import org.ferris.journal.gui.view.button.KDeleteButton;
import org.ferris.journal.gui.view.button.KNewButton;
import org.ferris.journal.gui.view.button.KSaveButton;
import org.ferris.journal.gui.view.combobox.KJournalComboBox;
import org.ferris.journal.gui.view.combobox.KJournalComboBoxModel;
import org.ferris.journal.gui.view.datepicker.KEntryDateDatePicker;
import org.ferris.journal.gui.view.dialog.KErrorDialog;
import org.ferris.journal.gui.view.editorpane.KEntryTextPane;
import org.ferris.journal.gui.view.textfield.KEntrySubjectTextField;
import org.ferris.journal.jws.journal.Journal;
import org.ferris.journal.jws.journalentry.JournalEntry;
import org.ferris.swing.InvokeAndWait;
import org.ferris.swing.ui.ThrowableDialog;

public 
class 
	KEntryFrame 
extends 
	KDefaultFrame 
implements 
	  ActionListener
	, ReleaseObserver
	, OperationObserver
	, WindowFocusListener
	, ItemListener
	, DocumentListener
	, JournalEntryObserver
	, JournalObserver
{
	private static final long serialVersionUID = 8986611052518547576L;

	private final Logger log = Logger.getLogger(getClass());  //  @jve:decl-index=0:
	
	private Model model; //  @jve:decl-index=0:
	
	private EntryController controller; //  @jve:decl-index=0:

	private JPanel jContentPane = null;

	private JPanel mainPanel = null;

	private KNewButton newButton = null;

	private JPanel buttonPanel = null;

	private KDeleteButton deleteButton = null;

	private KSaveButton saveButton = null;

	private JPanel statusPanel = null;

	private JLabel statusLabel = null;	

	private JPanel entryPanel = null;

	private JLabel journalLabel = null;

	private JLabel dateLabel = null;

	private JLabel subjectLabel = null;

	private JLabel entryLabel = null;

	private KJournalComboBox journalComboBox = null;

	private KEntrySubjectTextField subjectText = null;

	private KEntryTextPane entryTextPane = null;

	private KEntryDateDatePicker dateDatePicker = null;

	private JMenuBar entryFrameMenuBar = null;

	private JMenu fileMenu = null;

	private JMenuItem exitMenuItem = null;

	private JScrollPane entryScrollPane = null;

	private JMenu journalsMenu = null;

	private JMenuItem addEditMenuItem = null;

	private JMenu searchMenu = null;

	private JMenuItem searchMenuItem = null;
	
	private JournalEntry journalEntryBeingEdited;  //  @jve:decl-index=0:
	
	/**
	 * This method initializes 
	 * 
	 */
	public KEntryFrame() {
		super();
		initialize();
	}
	
	/**
	 * This method initializes 
	 */
	public KEntryFrame(EntryController controller, Model model) {
		super();
		initialize(controller, model);
	}

	/**
	 * This method initializes this
	 * 
	 */
	public void initialize(EntryController controller, Model model) {		
		this.controller = controller;
		this.model = model;		
		initialize();
		registerObservers();
	}
	
	private void registerObservers() {
		this.model.registerObserver((ReleaseObserver)this);
		this.model.registerObserver((OperationObserver)this);
		this.model.registerObserver((JournalEntryObserver)this);
		this.model.registerObserver((JournalObserver)this);
	}
	private void removeObservers() {
		this.model.removeObserver((ReleaseObserver)this);
		this.model.removeObserver((OperationObserver)this);
		this.model.removeObserver((JournalEntryObserver)this);
		this.model.removeObserver((JournalObserver)this);
	}
	
	public void dispose() {
		try {
			removeObservers();
		} catch (Throwable ignore) {}
		super.dispose();
	}
	
	/**
	 * This method initializes this
	 * 
	 */
	private void initialize() {
        this.setSize(new Dimension(573, 439));
        this.setJMenuBar(getEntryFrameMenuBar());
        this.setContentPane(getJContentPane());       
        this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setLocationRelativeTo(null);
        setTitle(getString("entry.frame.title"));
        addWindowFocusListener(this);
	}
	
	/**
	 * This method initializes jContentPane	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	public JPanel getJContentPane() {
		if (jContentPane == null) {
			GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
			gridBagConstraints21.gridx = 1;
			gridBagConstraints21.fill = GridBagConstraints.HORIZONTAL;
			gridBagConstraints21.gridwidth = 1;
			gridBagConstraints21.weighty = 0.0;
			gridBagConstraints21.anchor = GridBagConstraints.SOUTH;
			gridBagConstraints21.gridy = 4;
			GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
			gridBagConstraints11.gridx = 0;
			gridBagConstraints11.fill = GridBagConstraints.HORIZONTAL;
			gridBagConstraints11.insets = new Insets(0, 10, 0, 10);
			gridBagConstraints11.gridy = 2;
			GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
			gridBagConstraints2.gridx = 1;
			gridBagConstraints2.fill = GridBagConstraints.HORIZONTAL;
			gridBagConstraints2.insets = new Insets(10, 10, 10, 10);
			gridBagConstraints2.gridy = 3;
			GridBagConstraints gridBagConstraints = new GridBagConstraints();
			gridBagConstraints.gridx = 1;
			gridBagConstraints.fill = GridBagConstraints.BOTH;
			gridBagConstraints.anchor = GridBagConstraints.NORTH;
			gridBagConstraints.weighty = 1.0;
			gridBagConstraints.weightx = 1.0;
			gridBagConstraints.insets = new Insets(10, 10, 0, 10);
			gridBagConstraints.gridy = 1;
			jContentPane = new JPanel();
			jContentPane.setLayout(new GridBagLayout());
			jContentPane.add(getMainPanel(), gridBagConstraints);
			jContentPane.add(getButtonPanel(), gridBagConstraints2);
			jContentPane.add(getStatusPanel(), gridBagConstraints21);
		}
		return jContentPane;
	}
	
	/**
	 * This method initializes statusLabel
	 * 
	 * @return javax.swing.JLabel
	 */
	private JLabel getStatusLabel() {
		if (statusLabel == null) {
			statusLabel = new JLabel(" ");
		}
		return statusLabel;
	}

	/**
	 * This method initializes mainPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getMainPanel() {
		if (mainPanel == null) {
			GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
			gridBagConstraints1.fill = GridBagConstraints.BOTH;
			gridBagConstraints1.weighty = 1.0;
			gridBagConstraints1.weightx = 1.0;
			mainPanel = new JPanel();
			mainPanel.setLayout(new GridBagLayout());
			mainPanel.setBorder(BorderFactory.createEtchedBorder(EtchedBorder.LOWERED));
			mainPanel.add(getEntryPanel(), gridBagConstraints1);
		}
		return mainPanel;
	}

	/**
	 * This method initializes loginButton	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private KNewButton getNewButton() {
		if (newButton == null) {
			newButton = new KNewButton();
			newButton.addActionListener(this);
		}
		return newButton;
	}

	/**
	 * This method initializes buttonPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getButtonPanel() {
		if (buttonPanel == null) {
			GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
			gridBagConstraints3.anchor = GridBagConstraints.EAST;
			gridBagConstraints3.gridx = -1;
			gridBagConstraints3.gridy = -1;
			gridBagConstraints3.insets = new Insets(8, 5, 8, 5);
			buttonPanel = new JPanel();
			buttonPanel.setLayout(new FlowLayout(FlowLayout.TRAILING));
			buttonPanel.add(getSaveButton(), null);
			buttonPanel.add(getDeleteButton(), null);
			buttonPanel.add(getNewButton(), null);
		}
		return buttonPanel;
	}

	/**
	 * This method initializes registerButton	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getDeleteButton() {
		if (deleteButton == null) {
			deleteButton = new KDeleteButton();
			deleteButton.setVisible(false);
			deleteButton.addActionListener(this);
		}
		return deleteButton;
	}

	/**
	 * This method initializes exitButton	
	 * 	
	 * @return org.ferris.journal.exit.ExitButton	
	 */
	private KSaveButton getSaveButton() {
		if (saveButton == null) {
			saveButton = new KSaveButton();
			saveButton.setEnabled(false);
			saveButton.addActionListener(this);
//			KeyStroke kssave
//				= KeyStroke.getKeyStroke("ctrl S");
		}
		return saveButton;
	}

	

	public void released() {
		log.info("ENTER: relase()");
		System.out.println("Are you sure you want to exit?");		
	}

	
	/**
	 * This method initializes statusPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getStatusPanel() {
		if (statusPanel == null) {
			FlowLayout flowLayout = new FlowLayout();
			flowLayout.setHgap(0);
			flowLayout.setAlignment(java.awt.FlowLayout.LEFT);
			flowLayout.setVgap(0);
			statusLabel = getStatusLabel();			
			statusPanel = new JPanel();
			statusPanel.setLayout(flowLayout);
			statusPanel.setBorder(BorderFactory.createBevelBorder(BevelBorder.LOWERED));
			statusPanel.add(statusLabel, null);
		}
		return statusPanel;
	}

	public void performingOperation(final String description) {
		InvokeAndWait.run(
				new Runnable() {
					public void run() {
						getStatusLabel().setText(description);
					}
				}
			);
	}

	/**
	 * This method initializes entryPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getEntryPanel() {
		if (entryPanel == null) {
			GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
			gridBagConstraints12.anchor = GridBagConstraints.EAST;
			gridBagConstraints12.fill = GridBagConstraints.NONE;
			gridBagConstraints12.insets = new Insets(8, 5, 8, 5);
			GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
			gridBagConstraints10.fill = GridBagConstraints.BOTH;
			gridBagConstraints10.gridy = 4;
			gridBagConstraints10.weightx = 1.0;
			gridBagConstraints10.weighty = 1.0;
			gridBagConstraints10.gridwidth = 2;
			gridBagConstraints10.insets = new Insets(0, 5, 5, 5);
			gridBagConstraints10.gridx = 0;
			GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
			gridBagConstraints8.gridx = 1;
			gridBagConstraints8.fill = GridBagConstraints.NONE;
			gridBagConstraints8.anchor = GridBagConstraints.WEST;
			gridBagConstraints8.insets = new Insets(0, 5, 0, 5);
			gridBagConstraints8.weightx = 1.0;
			gridBagConstraints8.gridy = 0;
			GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
			gridBagConstraints9.fill = GridBagConstraints.HORIZONTAL;
			gridBagConstraints9.gridy = 2;
			gridBagConstraints9.weightx = 1.0;
			gridBagConstraints9.anchor = GridBagConstraints.CENTER;
			gridBagConstraints9.insets = new Insets(0, 5, 0, 5);
			gridBagConstraints9.gridx = 1;
			GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
			gridBagConstraints7.gridx = 1;
			gridBagConstraints7.fill = GridBagConstraints.NONE;
			gridBagConstraints7.weightx = 1.0;
			gridBagConstraints7.anchor = GridBagConstraints.WEST;
			gridBagConstraints7.insets = new Insets(0, 5, 0, 5);
			gridBagConstraints7.gridy = 1;
			GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
			gridBagConstraints6.gridx = 0;
			gridBagConstraints6.anchor = GridBagConstraints.EAST;
			gridBagConstraints6.insets = new Insets(8, 5, 8, 5);
			gridBagConstraints6.fill = GridBagConstraints.NONE;
			gridBagConstraints6.gridy = 3;
			entryLabel = new JLabel();
			entryLabel.setText(getString("label.entry"));
			GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
			gridBagConstraints5.gridx = 0;
			gridBagConstraints5.anchor = GridBagConstraints.EAST;
			gridBagConstraints5.insets = new Insets(8, 5, 8, 5);
			gridBagConstraints5.fill = GridBagConstraints.NONE;
			gridBagConstraints5.gridy = 2;
			subjectLabel = new JLabel();
			subjectLabel.setText(getString("label.subject"));
			GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
			gridBagConstraints4.gridx = 0;
			gridBagConstraints4.anchor = GridBagConstraints.EAST;
			gridBagConstraints4.insets = new Insets(8, 5, 8, 5);
			gridBagConstraints4.fill = GridBagConstraints.NONE;
			gridBagConstraints4.gridy = 1;
			dateLabel = new JLabel();
			dateLabel.setText(getString("label.date"));
			journalLabel = new JLabel();
			journalLabel.setText(getString("label.journal"));
			entryPanel = new JPanel();
			entryPanel.setLayout(new GridBagLayout());
			entryPanel.add(dateLabel, gridBagConstraints12);
			entryPanel.add(journalLabel, gridBagConstraints4);
			entryPanel.add(subjectLabel, gridBagConstraints5);
			entryPanel.add(entryLabel, gridBagConstraints6);
			entryPanel.add(getJournalComboBox(), gridBagConstraints7);
			entryPanel.add(getSubjectText(), gridBagConstraints9);
			entryPanel.add(getDateDatePicker(), gridBagConstraints8);
			entryPanel.add(getEntryScrollPane(), gridBagConstraints10);
		}
		return entryPanel;
	}

	/**
	 * This method initializes journalComboBox	
	 * 	
	 * @return javax.swing.JComboBox	
	 */
	private KJournalComboBox getJournalComboBox() {
		if (journalComboBox == null) {
			if (this.model == null) { 
				this.model = new ModelForVisualEditor();
			}
			journalComboBox = new KJournalComboBox(
				new KJournalComboBoxModel(model)
			);
			journalComboBox.addItemListener(this);
		}
		return journalComboBox;
	}

	/**
	 * This method initializes subjectText	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private KEntrySubjectTextField getSubjectText() {
		if (subjectText == null) {
			subjectText = new KEntrySubjectTextField();
			subjectText.getDocument().addDocumentListener(this);
		}
		return subjectText;
	}

	/**
	 * This method initializes entryEditorPane	
	 * 	
	 * @return javax.swing.JEditorPane	
	 */
	private KEntryTextPane getEntryTextPane() {
		if (entryTextPane == null) {
			entryTextPane = new KEntryTextPane();
			entryTextPane.setPreferredSize(new Dimension(100, 100));
			entryTextPane.setSize(new Dimension(100, 198));
			entryTextPane.getDocument().addDocumentListener(this);
		}
		return entryTextPane;
	}

	/**
	 * This method initializes dateDatePicker	
	 * 	
	 * @return org.jdesktop.swingx.JXDatePicker	
	 */
	private KEntryDateDatePicker getDateDatePicker() {
		if (dateDatePicker == null) {
			dateDatePicker = new KEntryDateDatePicker();
			dateDatePicker.setDate(getDefaultDateDatePickerDate());
			dateDatePicker.addActionListener(this);
			dateDatePicker.getEditor().getDocument().addDocumentListener(this);
			dateDatePicker.getEditor().addFocusListener(
				new FocusListener() {

					public void focusGained(FocusEvent arg0) {
						focusedGained = 1;
						log.info("Focus gained: " + focusedGained);					
					}

					public void focusLost(FocusEvent arg0) {
						focusedGained = 1;
						log.info("Focus lost: " + focusedGained);						
					}
					
				}
			);
		}
		return dateDatePicker;
	}
	
	
	private Date defaultDateDatePickerDate;
	private Date getDefaultDateDatePickerDate()
	{
		return (defaultDateDatePickerDate == null) ? new Date() : defaultDateDatePickerDate;
	}
	
	/**
	 * This method initializes entryFrameMenuBar	
	 * 	
	 * @return javax.swing.JMenuBar	
	 */
	private JMenuBar getEntryFrameMenuBar() {
		if (entryFrameMenuBar == null) {
			entryFrameMenuBar = new JMenuBar();
			entryFrameMenuBar.add(getFileMenu());
			entryFrameMenuBar.add(getJournalsMenu());
			entryFrameMenuBar.add(getSearchMenu());
		}
		return entryFrameMenuBar;
	}

	/**
	 * This method initializes fileMenu	
	 * 	
	 * @return javax.swing.JMenu	
	 */
	private JMenu getFileMenu() {
		if (fileMenu == null) {
			fileMenu = new JMenu();
			fileMenu.setText(getString("file"));
			fileMenu.add(getExitMenuItem());
		}
		return fileMenu;
	}

	/**
	 * This method initializes exitMenuItem	
	 * 	
	 * @return javax.swing.JMenuItem	
	 */
	private JMenuItem getExitMenuItem() {
		if (exitMenuItem == null) {
			exitMenuItem = new JMenuItem();
			exitMenuItem.setText(getString("exit"));
			exitMenuItem.setActionCommand("exit");
			exitMenuItem.addActionListener(this);
		}
		return exitMenuItem;
	}

	/**
	 * This method initializes entryScrollPane	
	 * 	
	 * @return javax.swing.JScrollPane	
	 */
	private JScrollPane getEntryScrollPane() {
		if (entryScrollPane == null) {
			entryScrollPane = new JScrollPane();
			entryScrollPane.setViewportView(getEntryTextPane());
		}
		return entryScrollPane;
	}

	/**
	 * This method initializes journalsMenu	
	 * 	
	 * @return javax.swing.JMenu	
	 */
	private JMenu getJournalsMenu() {
		if (journalsMenu == null) {
			journalsMenu = new JMenu();
			journalsMenu.setText(getString("journals"));
			journalsMenu.add(getAddEditMenuItem());
		}
		return journalsMenu;
	}

	/**
	 * This method initializes addEditMenuItem	
	 * 	
	 * @return javax.swing.JMenuItem	
	 */
	private JMenuItem getAddEditMenuItem() {
		if (addEditMenuItem == null) {
			addEditMenuItem = new JMenuItem();
			addEditMenuItem.setText(getString("add_edit"));
			addEditMenuItem.setActionCommand("add~edit~journals");
			addEditMenuItem.addActionListener(this);
		}
		return addEditMenuItem;
	}

	/**
	 * This method initializes searchMenu	
	 * 	
	 * @return javax.swing.JMenu	
	 */
	private JMenu getSearchMenu() {
		if (searchMenu == null) {
			searchMenu = new JMenu();
			searchMenu.setText(getString("search"));
			searchMenu.add(getSearchMenuItem());
		}
		return searchMenu;
	}

	/**
	 * This method initializes searchMenuItem	
	 * 	
	 * @return javax.swing.JMenuItem	
	 */
	private JMenuItem getSearchMenuItem() {
		if (searchMenuItem == null) {
			searchMenuItem = new JMenuItem();
			searchMenuItem.setText(getString("search"));
			searchMenuItem.setActionCommand("search~search");
			searchMenuItem.addActionListener(this);
		}
		return searchMenuItem;
	}

	
	
	
	/////////////////////////////////////////////////////////////////
	//
	// WindowFocusListener
	//
	/////////////////////////////////////////////////////////////////
	public void windowGainedFocus(WindowEvent e) {
		this.model.registerObserver((OperationObserver)this);		
	}

	public void windowLostFocus(WindowEvent e) {
		this.model.removeObserver((OperationObserver)this);		
	}

	
	
	
	
	/////////////////////////////////////////////////////////////////
	//
	// ItemListener
	//
	/////////////////////////////////////////////////////////////////	
	public void itemStateChanged(ItemEvent evnt) 
	{
		if (!getSaveButton().isEnabled()) {
			getSaveButton().setEnabled(true);
		}		
	}
	
	
	
	private int focusedGained = 0;

	
	/////////////////////////////////////////////////////////////////
	//
	// DocumentListener
	//
	/////////////////////////////////////////////////////////////////
	public void changedUpdate(DocumentEvent e) {		
		if (!getSaveButton().isEnabled()) {			
			getSaveButton().setEnabled(true);
		}
	}
	public void removeUpdate(DocumentEvent e) 
	{
		if (e.getDocument().equals(getDateDatePicker().getEditor().getDocument()))
		{
			log.info("r fg: " + focusedGained);
			if (focusedGained == 1) {
				focusedGained++;
				return;
			}
		}
		
		if (!getSaveButton().isEnabled()) {			
			getSaveButton().setEnabled(true);
		}
	}
	public void insertUpdate(DocumentEvent e)
	{
		if (e.getDocument().equals(getDateDatePicker().getEditor().getDocument()))
		{
			log.info("i fg: " + focusedGained);
			if (focusedGained == 2) {
				focusedGained++;
				return;
			}
		}
		if (!getSaveButton().isEnabled()) {			
			getSaveButton().setEnabled(true);
		}
	}	
	
	
	
	
	/////////////////////////////////////////////////////////////////
	// 
	// ActionListener
	//
	/////////////////////////////////////////////////////////////////
	public void actionPerformed(ActionEvent evnt) 
	{
		if ("exit".equals(evnt.getActionCommand())) {
			controller.exit();
		}
		else
		if ("add~edit~journals".equals(evnt.getActionCommand())) {
			controller.addEditJournals();
		}
		else
		if ("search~search".equals(evnt.getActionCommand())) {
			controller.searchJournalEntries();
		}
		else
		if ("datePickerCommit".equals(evnt.getActionCommand())) {
			if (!getSaveButton().isEnabled()) {
				getSaveButton().setEnabled(true);
			}
		}
		else
		if ("save".equals(evnt.getActionCommand())) 
		{
			// Error check
			List<String>
				explainations = new ArrayList<String>();
			
			// Validate Journal
			getJournalComboBox().validate(explainations);
			
			// Validate Date
			getDateDatePicker().validate(explainations);
			
			// Validate Subject
			getSubjectText().validate(explainations);
			
			// Validate text
			getEntryTextPane().validate(explainations);
						
			// Show errors?
			if (!explainations.isEmpty())  {
				new KErrorDialog(this, explainations);
				return;
			}
			
			// Save the date of the journal entry
			defaultDateDatePickerDate 
				= new Date(getDateDatePicker().getDate().getTime());
			
			// Save
			if (journalEntryBeingEdited == null) {
				controller.insertEntry(
					  getJournalComboBox().getSelectedJournal()
					, getDateDatePicker().getDate()
					, getSubjectText().getText()
					, getEntryTextPane().getText()
				);
			}
			else {
				controller.updateEntry(
					  journalEntryBeingEdited.getId()
					, getJournalComboBox().getSelectedJournal()
					, getDateDatePicker().getDate()
					, getSubjectText().getText()
					, getEntryTextPane().getText()
				);				
			}
		}
		else
		if ("new".equals(evnt.getActionCommand())) 
		{
			controller.newEntry();
		}
		else
		if ("delete".equals(evnt.getActionCommand())) 
		{
			String msg 
				= getString("entry.delete.msg");
			
			String title 
				= getString("entry.delete.title");
			
			Object[] options = { getString("yes"), getString("no") };
			
			int result =
			JOptionPane.showOptionDialog(
				  this  //parent component
				, msg //Object message
				, title //String title
				, JOptionPane.DEFAULT_OPTION//int optionType
				, JOptionPane.WARNING_MESSAGE//int messageType
				, null//Icon icon
				, options//Object[] options
				, options[1]//Object initialValue
			);
			log.info("Result: " + result);
			
			if (result == 0) 
			{				
				controller.deleteEntry(journalEntryBeingEdited);
			}
		}
		else
		{
			new ThrowableDialog(
				  new RuntimeException(
				   	  getString("exception.actioncommand.not.recognized", evnt.getActionCommand())
				  )
				, false
			);
		}
	}
	
	/////////////////////////////////////////////////////////////////
	//
	// JournalEntryObserver
	//
	/////////////////////////////////////////////////////////////////
	public void insertedJournalEntry(JournalEntry newJournal) 
	{
		getDeleteButton().setVisible(true);
		getSaveButton().setEnabled(false);
		
		journalEntryBeingEdited = newJournal;
	}
	
	public void updatedJournalEntry(JournalEntry updatedJournal) {
		insertedJournalEntry(updatedJournal);
	}
	

	public void newJournalEntry() {
		journalEntryBeingEdited = null;
		getJournalComboBox().setSelectedIndex(-1);
		getJournalComboBox().setBackground(getJournalComboBox().getOriginalBackgroundColor());
		
		getDateDatePicker().setDate(getDefaultDateDatePickerDate());
		getDateDatePicker().setBackground(getDateDatePicker().getOriginalBackgroundColor());
		
		getSubjectText().setText("");
		getSubjectText().setBackground(getSubjectText().getOriginalBackgroundColor());
		
		getEntryTextPane().setText("");
		getEntryTextPane().setBackground(getEntryTextPane().getOriginalBackgroundColor());
		
		getDeleteButton().setVisible(false);
		getSaveButton().setEnabled(false);
		getJournalComboBox().grabFocus();		
	}
	
	public void deletedJournalEntry(JournalEntry deletedJournal) {
		newJournalEntry();
		JOptionPane.showMessageDialog(
			  this											// parent
			, getString("entry.deleted.dialog.message")		// message
			, getString("entry.deleted.dialog.title")		// title
			, JOptionPane.INFORMATION_MESSAGE				// message type
		);
		
	}

	public void editJournalEntry(JournalEntry editMe) 
	{
		journalEntryBeingEdited = editMe;
		
		getJournalComboBox().setSelectedItem(journalEntryBeingEdited.getJournal());
		getDateDatePicker().setDate(journalEntryBeingEdited.getDay().getTime());
		getSubjectText().setText(journalEntryBeingEdited.getSubject());
		getEntryTextPane().setText(journalEntryBeingEdited.getEntry());
		getEntryTextPane().setCaretPosition(0);
		
		
		getDeleteButton().setVisible(true);
		getSaveButton().setEnabled(false);
		getJournalComboBox().grabFocus();
	}
	/////////////////////////////////////////////////////////////////

	
	/////////////////////////////////////////////////////////////////
	//
	// JournalObserver
	//
	/////////////////////////////////////////////////////////////////
	@Override
	public void deletedJournal(Journal deletedJournal) {
		log.info("ENTER: deletedJournal()");
		getJournalComboBox().getJournalComboBoxModel().deletedJournal(deletedJournal);
		log.info("EXIT: deletedJournal()");
	}

	@Override
	public void editJournal(Journal editMe) {
		log.info("ENTER: editJournal()");
		getJournalComboBox().getJournalComboBoxModel().editJournal(editMe);
		log.info("EXIT: editJournal()");
	}

	@Override
	public void insertedJournal(Journal newJournal) {
		log.info("ENTER: insertedJournal()");
		getJournalComboBox().getJournalComboBoxModel().insertedJournal(newJournal);
		log.info("EXIT: insertedJournal()");
	}

	@Override
	public void newJournal() {
		log.info("ENTER: newJournal()");
		getJournalComboBox().getJournalComboBoxModel().newJournal();
		log.info("EXIT: newJournal()");	
	}

	@Override
	public void updatedJournal(Journal updatedJournal) {
		log.info("ENTER: updatedJournal()");
		getJournalComboBox().getJournalComboBoxModel().updatedJournal(updatedJournal);
		if (!updatedJournal.getIsActive()) {
			getJournalComboBox().setSelectedIndex(-1);
		}
		log.info("EXIT: updatedJournal()");
	}
	/////////////////////////////////////////////////////////////////

	

}  //  @jve:decl-index=0:visual-constraint="74,13"

