package org.ferris.journal.gui.view.table;

import static org.ferris.journal.gui.i18n.i18n.getString;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

import javax.swing.table.DefaultTableModel;

import org.ferris.journal.jws.journalentry.JournalEntry;

public class KEntryTableModel extends DefaultTableModel 
{
	private static final long serialVersionUID = -7213920218024889576L;
	private static List<JournalEntry> empty = new ArrayList<JournalEntry>(0);
	private static SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy");
	

	private int indexOf(JournalEntry e)
	{
		int idx = -1;
		for (JournalEntry entry : getEntries()) {
			idx++;
			if (entry.getId().equals(e.getId())) {
				return idx;
			}
		}
		return -1;
	}
	
	
	
	private List<JournalEntry> entries;
	
	
	
	public List<JournalEntry> getEntries() {
		if (entries == null) {
			return empty;
		} else {
			return entries;
		}
	}

	public void setEntries(List<JournalEntry> newEntries) {
		if (entries != null) {
			entries.clear();
		}
		entries = new ArrayList<JournalEntry>(newEntries.size());
		entries.addAll(newEntries);
		fireTableDataChanged();
	}
	
	
	public KEntryTableModel(List<JournalEntry> entries)
	{	
		setEntries(entries);
		addColumn(getString("column.day"));
		addColumn(getString("column.journal"));
		addColumn(getString("column.subject"));
	}

	public boolean isCellEditable(int row, int column) {
		return false;
	}
	
	public int getColumnCount() {
		return 3;
	}

	public int getRowCount() {
		return getEntries().size();
	}

	public Object getValueAt(int row, int column) {
		JournalEntry entry
			= getEntries().get(row);
		switch (column)
		{
			case 0:
				return simpleDateFormat.format(entry.getDay().getTime());
			case 1:
				return entry.getJournal().getName();
			case 2:
				return entry.getSubject();
			default:
				throw new RuntimeException("Table row: \""+row+"\" column: \""+column+"\" for journal entry list is not understood.");
		}
	}

	public int deleteEntry(JournalEntry deletedJournal) 
	{
		int idx = indexOf(deletedJournal);
		if (idx != -1) {
			getEntries().remove(idx);
			fireTableDataChanged();
		}
		return idx;
	}

	public int addEntry(JournalEntry newJournal) {
		getEntries().add(newJournal);
		fireTableDataChanged();
		return getEntries().size() - 1;
	}

	public int updateEntry(JournalEntry updatedJournal) 
	{
		int idx = indexOf(updatedJournal);
		if (idx != -1) {
			getEntries().remove(idx);
			getEntries().add(idx, updatedJournal);		
			fireTableDataChanged();
		}
		return idx;
	}

}
