package org.ferris.journal.gui.view.textfield;

import java.awt.Color;
import java.util.List;

import javax.swing.JPasswordField;

import org.apache.commons.lang.ArrayUtils;
import org.ferris.constraint.Check;
import org.ferris.constraint.Constraint;

public abstract class KAbstractPasswordField extends JPasswordField
{
	private static final long serialVersionUID = 1356201490390316732L;
	private Color originalBackgroundColor;
	
	public KAbstractPasswordField() {
		super();
		originalBackgroundColor = getBackground();
	}
	
	public abstract Constraint<String> getConstraint(); 
	
	public abstract String getExplaination(Check check); 
	
	public KAbstractPasswordField validate(List<String> explainations) 
	{
		setBackground(originalBackgroundColor);
		
		String p =
			ArrayUtils.isEmpty(getPassword())
			? "" : new String(getPassword());
		
		Check check 
			= getConstraint().check(p);
		
		p = null;
		
		if (check != null) {
			setBackground(Color.red);
			explainations.add(getExplaination(check));
		}
		
		return this;
	}
	
	public Color getOriginalBackgroundColor() {
		return originalBackgroundColor;
	}
	
	
}
