package org.ferris.journal.gui.view.textfield;

import static org.ferris.journal.gui.i18n.i18n.getString;

import org.ferris.constraint.Check;
import org.ferris.constraint.Constraint;
import org.ferris.constraint.NotNull;
import org.ferris.constraint.StringLengthBetween;

public class KJournalNameTextField extends KAbstractTextField
{	
	private static final long serialVersionUID = -352120234314107743L;

	private Constraint<String> constraint;
	
	private int getMin() {
		return 1;
	}
	
	private int getMax() {
		return 50;
	}
	
	
	public KJournalNameTextField()  {
		super();
	}
	
	@Override
	public Constraint<String> getConstraint()
	{
		if (constraint == null) {
			constraint =
				new NotNull<String>
				(
					new StringLengthBetween
					(
					  getMin(), true,		// min must be greater than or equal to... 
					  getMax(), true		// max must be less than or equal to... 
					)
				);
		}
		return constraint;
	}

	@Override
	public String getExplaination(Check check)
	{
		if (check.equals(Check.IsNull)) {
			return getString("journal.name.malformed.null");
		}
		else
		if (check.equals(Check.LessThan)) {
			return getString("journal.name.malformed.empty");
		}
		else
		if (check.equals(Check.GreaterThan)) {
			return getString("journal.name.malformed.toolong", getMax(), getText().length());
		}
		else {
			throw new RuntimeException(
				getString("exception.check.not.recognized", check)
			);
		}
	}

}
