package org.ferris.journal.gui.view.textfield;

import static org.ferris.journal.gui.i18n.i18n.getString;

import org.ferris.constraint.Check;
import org.ferris.constraint.Constraint;

public class KKeywordTextField extends KAbstractTextField
{	
	private static final long serialVersionUID = -352120234314107743L;

	private Constraint<String> constraint;
	
	public KKeywordTextField()  {
		super();
	}
	
	class None implements Constraint<String> {
		public Check check(String checkMe) {
			return null;
		}
	}
	
	@Override
	public Constraint<String> getConstraint()
	{
		if (constraint == null) {
			constraint =
				new None();
		}
		return constraint;
	}

	@Override
	public String getExplaination(Check check)
	{
		throw new RuntimeException(
			getString("exception.check.not.recognized", check)
		);
	}

}
