package org.ferris.axis.components.net;

import java.io.InputStream;
import java.net.Socket;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.Hashtable;

import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;

import org.apache.axis.components.net.BooleanHolder;
import org.apache.log4j.Logger;

public class MySecureSocketFactory implements org.apache.axis.components.net.SecureSocketFactory 
{
	private Logger log = Logger.getLogger(getClass());
	
	private SSLSocketFactory factory;
	
	public static void main(String[] args)
	throws Exception {
		new MySecureSocketFactory(new Hashtable<Object,Object>());
	}
	
	public MySecureSocketFactory(Hashtable<? extends Object, ? extends Object> table)
	throws Exception
	{
		// This url gives an example of how to create a 
		// factory which will accept any certificate, which means
		// connecting to a custom keystore is not neccessary.
		//
		// http://exampledepot.com/egs/javax.net.ssl/TrustAll.html?l=rel
		//
		log.info("Get default type");
		String defaultType = KeyStore.getDefaultType();
		log.info(String.format("defaultType=\"%s\"",defaultType));
		
		log.info(String.format("Get KeyStore instance"));
		KeyStore ks = KeyStore.getInstance(defaultType);
		
		String keystore = "/FerrisKeystore";
		log.info(String.format("Get class path resource \"%s\"",keystore));		
		InputStream is = this.getClass().getResourceAsStream(keystore);
		if (is == null) {
			throw new RuntimeException(
				String.format("The class path resource \"%s\" is not found!", keystore)
			);
		}
		
		log.info(String.format("Create char[]"));
		char [] password = new char[]{'t','o','m','c','a','t'};
		
		log.info(String.format("Load KeyStore"));
		ks.load(is, password);
		
		log.info(String.format("Loop over KeyStore aliases..."));
		for (Enumeration<String> enu=ks.aliases(); enu.hasMoreElements();) {
			log.info(String.format("Alias=\"%s\"",String.valueOf(enu.nextElement())));
		}
		
		log.info(String.format("Get KeyManagerFactory instance"));
		KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
		log.info(String.format("Init KeyManagerFactory"));
		kmf.init(ks,password);
		
		log.info(String.format("Get TrustManagerFactory instance"));
		TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
		log.info(String.format("Init TrustManagerFactory"));
		tmf.init(ks);
		
		log.info(String.format("Get SSLContext instance"));
		SSLContext context = SSLContext.getInstance("SSL");
		log.info(String.format("Init SSLContext"));
		context.init(kmf.getKeyManagers(), tmf.getTrustManagers(), new SecureRandom());

		log.info(String.format("Get SocketFactory"));
		factory = context.getSocketFactory();
	}
	
        @Override
	public Socket create(
			  String host
			, int port
			, StringBuffer otherHeaders
			, BooleanHolder useFullUrl
	) throws Exception 
	{
		log.info(
			String.format(
				"ENTER: create(%s, %d, %s, %s)"
				, host
				, port
				, (otherHeaders == null) ? "null" : otherHeaders.toString()
				, (useFullUrl == null) ? "null" : useFullUrl.value
		    )
		);
		port = (port == -1) ? 443 : port;		
		return factory.createSocket(host, port);
	}

}
