package org.ferris.journal.gui.data;

import java.util.Comparator;

import org.ferris.journal.jws.journalentry.JournalEntry;

public class JournalEntryComparator implements Comparator<JournalEntry> 
{
	public static Comparator<JournalEntry> CREATED_ON_ASC
		= new JournalEntryComparatorForCreatedOn(1);
	
	public static Comparator<JournalEntry> CREATED_ON_DESC
		= new JournalEntryComparatorForCreatedOn(2);
	
	public static Comparator<JournalEntry> DAY_ASC
		= new JournalEntryComparatorForDay(1);

	public static Comparator<JournalEntry> DAY_DESC
		= new JournalEntryComparatorForDay(2);
	
	
	static class JournalEntryComparatorForCreatedOn implements Comparator<JournalEntry> 
	{
		private int direction = 0;
		public JournalEntryComparatorForCreatedOn(int i) {
			direction = i;
		}
		public int compare(JournalEntry o1, JournalEntry o2) {
			if (direction == 1) {
				return o1.getCreatedOn().compareTo(o2.getCreatedOn());
			} else {
				return o2.getCreatedOn().compareTo(o1.getCreatedOn());
			}
		}
	}
	
	static class JournalEntryComparatorForDay implements Comparator<JournalEntry> 
	{
		private int direction = 0;
		public JournalEntryComparatorForDay(int i) {
			direction = i;
		}
		public int compare(JournalEntry o1, JournalEntry o2) {
			if (direction == 1) {
				return o1.getDay().compareTo(o2.getDay());
			} else {
				return o2.getDay().compareTo(o1.getDay());
			}
		}
	}
	
	private Comparator<JournalEntry> comparator;

	public int compare(JournalEntry o1, JournalEntry o2) {
		return comparator.compare(o1, o2);
	}
}


