package org.ferris.journal.gui.data;

import static org.ferris.journal.gui.i18n.i18n.getString;

import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;

import javax.xml.rpc.ServiceException;

import org.apache.axis.client.Stub;
import org.ferris.journal.jws.journalentry.JournalEntry;
import org.ferris.journal.jws.journalentry.JournalEntryJws;
import org.ferris.journal.jws.journalentry.JournalEntryJwsServiceLocator;

public class JournalEntryDataByAxis extends JournalEntryData 
{	
	private final String $urlstr = DataByAxis.HOST_AND_CONTEXT + "journal_entry.jws";
	private URL $url;
	private URL getUrl() {
		if ($url == null) 
		{
			try {
				$url = new URL($urlstr);
			}
			catch (MalformedURLException e) {
				throw new RuntimeException(
					getString("exception.malformed.url", $urlstr)
				);
			}
		}
		return $url;
	}
	
	
	private JournalEntryJws getJws() {
		JournalEntryJwsServiceLocator loc
		= new JournalEntryJwsServiceLocator();

		JournalEntryJws jws = null;
		try {			
			jws = loc.getJournalEntryJwsPort(getUrl());
			setCredentials((Stub)jws);
		} catch (ServiceException e) {
			throw new RuntimeException(e);
		}
		return jws;
	}
	
	public String test(String echoMeBack) 
	{
		try {			
			return getJws().test(echoMeBack);	
		} catch (RemoteException e) {
			throw new RuntimeException(e);
		}
	}
	
	

	@Override
	public Boolean delete(long accountId, long journalEntryId) {
		try {
			return getJws().delete(accountId, journalEntryId);			
		} catch (RemoteException e) {
			throw new RuntimeException(e);
		}
	}


	@Override
	public List<JournalEntry> search(long accountId, String keyword, long[] journalIds, Calendar minInclusive, Calendar maxInclusive)
	{
		try {
			JournalEntry [] js
				= getJws().search(accountId, keyword, journalIds, minInclusive, maxInclusive);
			
			return (js == null) ? new ArrayList<JournalEntry>() : Arrays.asList(js);	
			
		} catch (RemoteException e) {
			throw new RuntimeException(e);
		}
	}


	@Override
	public JournalEntry insert(JournalEntry entry) {
		try {
			return getJws().insert(entry);			
		} catch (RemoteException e) {
			throw new RuntimeException(e);
		}
	}


	@Override
	public JournalEntry update(JournalEntry entry) {
		try {
			return getJws().update(entry);			
		} catch (RemoteException e) {
			throw new RuntimeException(e);
		}
	}
}
