package org.ferris.journal.gui.main;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.util.Enumeration;

import org.apache.log4j.FileAppender;
import org.apache.log4j.Logger;
import org.ferris.journal.gui.controller.LoginController;
import org.ferris.journal.gui.model.ModelForApplication;
import org.ferris.swing.ui.ThrowableDialog;

public class Main {

	private static Logger log = Logger.getLogger(Main.class);
	/**
	 * @param args
	 */
	public static void main(String[] args) 
	throws Throwable
	{
		try {
			Policy.setPolicy(
                new Policy()
                {
                    public PermissionCollection getPermissions(CodeSource codesource)
                    {
                        Permissions perms = new Permissions();
                        perms.add(new AllPermission());
                        return(perms);
                    }

                    public void refresh()
                    {
                    }
                }
            );
		}
		catch (Throwable t) {
			throw t;
		}
		
		Clown c = new Clown();
		Thread.setDefaultUncaughtExceptionHandler(c);
		
		String [] keys
			= new String[]{
				  "java.vm.specification.vendor"
				, "java.vendor"
				, "java.runtime.version"
				, "java.home"
				, "java.vm.version"
		};
		for (int i = 0; i < keys.length; i++) {
			log.info(keys[i] + ": " + System.getProperty(keys[i]));
		}
		
		whereIsTheLogFile();
		
		c.loginController = new LoginController(new ModelForApplication());
	}	

	static class Clown implements Thread.UncaughtExceptionHandler {
		public LoginController loginController;
		
		public void uncaughtException(Thread t, Throwable e) 
		{
			if (loginController != null) {
				loginController.disposeView();
			}
			new ThrowableDialog(e, true).setVisible(true);
		}
	}
	
	
	@SuppressWarnings("unchecked")
	private static void whereIsTheLogFile() 
	{
		log.info("ENTER: whereIsTheLogFile()");
		
		String message = null;
		
		Logger root = Logger.getRootLogger();
		if (root == null) {
			message = "Opps, no root logger found. Sorry :(";
		}
					
		Enumeration enu = null;
		if (root != null) {
			enu = root.getAllAppenders();
			if (enu == null) {
				message = "Opps, no appenders found on root logger. Sorry :(";
			}
		}
		
		
		FileAppender appender = null;
		if (enu != null)
		{
			while (appender==null && enu.hasMoreElements()) {
				Object o = enu.nextElement();
				if (o instanceof FileAppender) {
					appender = (FileAppender)o;
				}
			}
			if (appender == null) {
				message = "Opps, no file appender found. Sorry :(";
			} else {
				try {
					message = "Log File: " + new File(appender.getFile()).getCanonicalPath();
				} catch (Throwable t) {
					StringWriter sw = new StringWriter();
					PrintWriter  pw = new PrintWriter(sw);
					t.printStackTrace(pw);
					pw.flush();
					message = sw.toString();
					pw.close();
				}
			}
		}
		
		if (message == null) {
			message = "Opps, no message. Sorry! :(";
		}
		
		log.info(message);
	}	
}

