package org.ferris.journal.gui.view.frame;

import static org.ferris.journal.gui.i18n.i18n.getString;

import java.awt.Image;

import javax.swing.JFrame;
import javax.swing.WindowConstants;

import org.ferris.journal.gui.view.images.ImageFactory;

public class KDefaultFrame extends JFrame {

	private static final long serialVersionUID = 1293876902756L;
	
	private static Image img
		= ImageFactory.getApplicationIcon();
	
	/**
	 * This is the default constructor
	 */
	public KDefaultFrame() {
		super();
		this.initialize();
	}

	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	private void initialize() {
		this.setTitle(getString("default.frame.title"));
		setIconImage(img);
		this.setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);
	}
	
	public void setTitle(String s) {
		super.setTitle(
			  getString("default.frame.title")
			+ ""
			+ getString("dash")
			+ ""
			+ s
		);
	}
}
