package org.ferris.journal.gui.view.frame;

import static org.ferris.journal.gui.i18n.i18n.getString;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.border.BevelBorder;
import javax.swing.border.EtchedBorder;

import org.ferris.journal.gui.controller.LoginController;
import org.ferris.journal.gui.model.Model;
import org.ferris.journal.gui.model.OperationObserver;
import org.ferris.journal.gui.model.ReleaseObserver;
import org.ferris.journal.gui.view.button.KExitButton;
import org.ferris.journal.gui.view.button.KLoginButton;
import org.ferris.journal.gui.view.button.KRegisterButton;
import org.ferris.journal.gui.view.dialog.KErrorDialog;
import org.ferris.journal.gui.view.panel.KCredentialsPanel;
import org.ferris.swing.InvokeAndWait;
import org.ferris.swing.ui.ThrowableDialog;

public class KLoginFrame extends KDefaultFrame implements ActionListener, ReleaseObserver, OperationObserver
{
	private static final long serialVersionUID = 8986611052518547576L;

	private Model model; //  @jve:decl-index=0:
	
	private LoginController controller; //  @jve:decl-index=0:

	private JPanel jContentPane = null;

	private JPanel mainPanel = null;

	private KCredentialsPanel credentialsPanel = null;

	private JButton loginButton = null;

	private JPanel buttonPanel = null;

	private JButton registerButton = null;

	private KExitButton exitButton = null;

	private JPanel statusPanel = null;

	private JLabel statusLabel = null;

	/**
	 * This method initializes 
	 * 
	 */
	public KLoginFrame() {
		super();
		initialize();
	}
	
	/**
	 * This method initializes 
	 */
	public KLoginFrame(LoginController controller, Model model) {
		super();
		initialize(controller, model);
	}

	/**
	 * This method initializes this
	 * 
	 */
	public void initialize(LoginController controller, Model model) {		
		this.controller = controller;
		this.model = model;		
		initialize();
		this.model.registerObserver((ReleaseObserver)this);
		this.model.registerObserver((OperationObserver)this);
	}
	
	public void dispose() {
		try {
			this.model.removeObserver((ReleaseObserver)this);
			this.model.removeObserver((OperationObserver)this);
		} catch (Throwable ignore) {}
		super.dispose();
	}
	
	/**
	 * This method initializes this
	 * 
	 */
	private void initialize() {
        this.setSize(new Dimension(390, 178));
        this.setContentPane(getJContentPane());
        
        setResizable(false);
        setLocationRelativeTo(null);
        setTitle(getString("login.frame.title"));
        setAlwaysOnTop(true);
	}
	
	private JLabel getStatusLabel() {
		if (statusLabel == null) {
			statusLabel = new JLabel();		
			statusLabel.setText(" ");
		}
		return statusLabel;
	}

	/**
	 * This method initializes jContentPane	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	public JPanel getJContentPane() {
		if (jContentPane == null) {
			GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
			gridBagConstraints21.gridx = 1;
			gridBagConstraints21.fill = GridBagConstraints.HORIZONTAL;
			gridBagConstraints21.gridwidth = 2;
			gridBagConstraints21.weighty = 1.0;
			gridBagConstraints21.anchor = GridBagConstraints.SOUTH;
			gridBagConstraints21.gridy = 2;
			GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
			gridBagConstraints11.gridx = 0;
			gridBagConstraints11.fill = GridBagConstraints.HORIZONTAL;
			gridBagConstraints11.insets = new Insets(0, 10, 0, 10);
			gridBagConstraints11.gridy = 2;
			GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
			gridBagConstraints2.gridx = 1;
			gridBagConstraints2.fill = GridBagConstraints.HORIZONTAL;
			gridBagConstraints2.insets = new Insets(10, 10, 10, 10);
			gridBagConstraints2.gridy = 1;
			GridBagConstraints gridBagConstraints = new GridBagConstraints();
			gridBagConstraints.gridx = 1;
			gridBagConstraints.fill = GridBagConstraints.HORIZONTAL;
			gridBagConstraints.anchor = GridBagConstraints.NORTH;
			gridBagConstraints.weighty = 0.0;
			gridBagConstraints.weightx = 1.0;
			gridBagConstraints.insets = new Insets(10, 10, 0, 10);
			gridBagConstraints.gridy = 0;
			jContentPane = new JPanel();
			jContentPane.setLayout(new GridBagLayout());
			jContentPane.add(getMainPanel(), gridBagConstraints);
			jContentPane.add(getButtonPanel(), gridBagConstraints2);
			jContentPane.add(getStatusPanel(), gridBagConstraints21);
		}
		return jContentPane;
	}

	/**
	 * This method initializes mainPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getMainPanel() {
		if (mainPanel == null) {
			GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
			gridBagConstraints1.gridx = 0;
			gridBagConstraints1.fill = GridBagConstraints.HORIZONTAL;
			gridBagConstraints1.weightx = 1.0;
			gridBagConstraints1.weighty = 0.0;
			gridBagConstraints1.gridy = 0;
			mainPanel = new JPanel();
			mainPanel.setLayout(new GridBagLayout());
			mainPanel.setBorder(BorderFactory.createEtchedBorder(EtchedBorder.LOWERED));
			mainPanel.add(getCredentialsPanel(), gridBagConstraints1);
		}
		return mainPanel;
	}

	/**
	 * This method initializes credentialsPanel	
	 * 	
	 * @return org.ferris.journal.login.CredentialsPanel	
	 */
	private KCredentialsPanel getCredentialsPanel() {
		if (credentialsPanel == null) {
			credentialsPanel = new KCredentialsPanel();
		}
		return credentialsPanel;
	}

	/**
	 * This method initializes loginButton	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getLoginButton() {
		if (loginButton == null) {
			loginButton = new KLoginButton();						
			loginButton.addActionListener(this);
			getRootPane().setDefaultButton(loginButton);
		}
		return loginButton;
	}

	/**
	 * This method initializes buttonPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getButtonPanel() {
		if (buttonPanel == null) {
			GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
			gridBagConstraints3.anchor = GridBagConstraints.EAST;
			gridBagConstraints3.gridx = -1;
			gridBagConstraints3.gridy = -1;
			gridBagConstraints3.insets = new Insets(8, 5, 8, 5);
			buttonPanel = new JPanel();
			buttonPanel.setLayout(new FlowLayout(FlowLayout.TRAILING));
			buttonPanel.add(getLoginButton(), null);
			buttonPanel.add(getRegisterButton(), null);
			buttonPanel.add(getExitButton(), null);
		}
		return buttonPanel;
	}

	/**
	 * This method initializes registerButton	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getRegisterButton() {
		if (registerButton == null) {
			registerButton = new KRegisterButton();			
			registerButton.addActionListener(this);
		}
		return registerButton;
	}

	/**
	 * This method initializes exitButton	
	 * 	
	 * @return org.ferris.journal.exit.ExitButton	
	 */
	private KExitButton getExitButton() {
		if (exitButton == null) {
			exitButton = new KExitButton();
			exitButton.addActionListener(this);
		}
		return exitButton;
	}

	
	/**
	 * Stuff which this form can do.
	 */
	public void actionPerformed(ActionEvent evnt) 
	{
		if ("exit".equals(evnt.getActionCommand())) {
			controller.exit();
		}
		else
		if ("register".equals(evnt.getActionCommand()))
		{
			List<String>
				errors = new ArrayList<String>();
			
			getCredentialsPanel().validate(errors);					
			
			if (!errors.isEmpty())  {
				new KErrorDialog(this, errors);
				return;
			}
			
			 JPasswordField pwd 
			 	= new JPasswordField(10);	
			 pwd.grabFocus();
			 
			 int action 
			 	= JOptionPane.showConfirmDialog(
			 			this, pwd,getString("confirm_password"),JOptionPane.OK_CANCEL_OPTION);
			
			 String repeatedPassword
			 	= (action == 0) ? new String(pwd.getPassword()) : null; 			   
			
			if (repeatedPassword != null)
			{
				// Are they equal?
				if (!Arrays.equals(getCredentialsPanel().getPassword(), repeatedPassword.toCharArray())) {
					errors.add(getString("password_mismatch"));
					new KErrorDialog(this, errors);
					getRegisterButton().doClick();
					return;
				}
				
				// Register
				controller.register(
					  getCredentialsPanel().getUsername()
					, getCredentialsPanel().getPassword()
				);
				
				return;
			}
		}
		else
		if ("login".equals(evnt.getActionCommand())) 
		{
			List<String>
				errors = new ArrayList<String>();
			
			getCredentialsPanel().validate(errors);					
			
			if (!errors.isEmpty())  {
				new KErrorDialog(this, errors);
				return;
			}
			
			System.out.println(errors);		
			
			controller.login(
				  getCredentialsPanel().getUsername()
				, getCredentialsPanel().getPassword()
			);
		}
		else
		{
			new ThrowableDialog(
				  new RuntimeException(
				   	  getString("exception.actioncommand.not.recognized", evnt.getActionCommand())
				  )
				, false
			);
		}
	}

	public void released() {
		System.out.println("Are you sure you want to exit?");		
	}

	
	/**
	 * This method initializes statusPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getStatusPanel() {
		if (statusPanel == null) {
			FlowLayout flowLayout = new FlowLayout();
			flowLayout.setHgap(0);
			flowLayout.setAlignment(java.awt.FlowLayout.LEFT);
			flowLayout.setVgap(0);
			statusLabel = getStatusLabel();			
			statusPanel = new JPanel();
			statusPanel.setLayout(flowLayout);
			statusPanel.setBorder(BorderFactory.createBevelBorder(BevelBorder.LOWERED));
			statusPanel.add(statusLabel, null);
		}
		return statusPanel;
	}

	public void performingOperation(final String description) {
		InvokeAndWait.run(
				new Runnable() {
					public void run() {
						getStatusLabel().setText(description);
					}
				}
			);
	}
	
	public void setVisible(boolean b) {		
		super.setVisible(b);
		InvokeAndWait.run(
			new Runnable() {
				public void run() {
					if (getCredentialsPanel().getUsername() != null && getCredentialsPanel().getUsername().length() > 0) {
						getCredentialsPanel().focusOnPassword();
					}
				}
			}
		);
	}
	

}  //  @jve:decl-index=0:visual-constraint="57,16"
