package org.ferris.journal.gui.view.frame;

import static org.ferris.journal.gui.i18n.i18n.getString;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.prefs.Preferences;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.border.BevelBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import org.apache.log4j.Logger;
import org.ferris.journal.gui.controller.SearchController;
import org.ferris.journal.gui.data.JournalEntryComparator;
import org.ferris.journal.gui.model.JournalEntryObserver;
import org.ferris.journal.gui.model.JournalEntrySearchObserver;
import org.ferris.journal.gui.model.Model;
import org.ferris.journal.gui.model.ModelForVisualEditor;
import org.ferris.journal.gui.model.OperationObserver;
import org.ferris.journal.gui.model.ReleaseObserver;
import org.ferris.journal.gui.view.button.KCloseButton;
import org.ferris.journal.gui.view.button.KEditButton;
import org.ferris.journal.gui.view.button.KExportAsTextButton;
import org.ferris.journal.gui.view.button.KSearchButton;
import org.ferris.journal.gui.view.datepicker.KEntryDateDatePicker;
import org.ferris.journal.gui.view.dialog.KErrorDialog;
import org.ferris.journal.gui.view.list.KJournalList;
import org.ferris.journal.gui.view.list.KJournalListModelForAllJournals;
import org.ferris.journal.gui.view.table.KEntryTable;
import org.ferris.journal.gui.view.table.KEntryTableModel;
import org.ferris.journal.gui.view.textfield.KKeywordTextField;
import org.ferris.journal.jws.journal.Journal;
import org.ferris.journal.jws.journalentry.JournalEntry;
import org.ferris.swing.InvokeAndWait;
import org.ferris.swing.ui.ThrowableDialog;

public 
class 
	KSearchFrame 
extends 
	KDefaultFrame 
implements 
	  ActionListener
	, ReleaseObserver
	, OperationObserver
	, JournalEntryObserver
	, JournalEntrySearchObserver
	, WindowFocusListener	
	, DocumentListener
	, ItemListener
{
	private static final long serialVersionUID = 8986611052518547576L;

	private final Logger log = Logger.getLogger(getClass());  //  @jve:decl-index=0:
	
	private Model model; //  @jve:decl-index=0:
	
	private SearchController controller; //  @jve:decl-index=0:
	
	private Preferences prefs = Preferences.userNodeForPackage(getClass()); //  @jve:decl-index=0:
	
	private JPanel jContentPane = null;

	private JPanel mainPanel = null;

	private JPanel buttonPanel = null;

	private JButton searchButton = null;

	private JButton closeButton = null;

	private JPanel statusPanel = null;

	private JLabel statusLabel = null;

	private JPanel inputPanel = null;

	private JLabel keywordLabel = null;

	private KKeywordTextField keywordText = null;
	
	private JLabel journalListLabel = null;

	private JLabel spacer = null;

	private JScrollPane entryTableScrollPane = null;

	private KEntryTable entryTable = null;

	private KEditButton editButton = null;

	private KExportAsTextButton exportButton = null;

	private JScrollPane journalsScrollPane = null;

	private KJournalList journalList = null;

	private JLabel dateRangeLabel = null;

	private JPanel dateRangePanel = null;

	private KEntryDateDatePicker minDateDatePicker = null;

	private JLabel toLabel = null;

	private KEntryDateDatePicker maxDateDatePicker = null;

	/**
	 * This method initializes and is only here 
	 * because the eclipse visual editor needs it.
	 */
	public KSearchFrame() {
		super();
		initialize();
	}
	
	
	/**
	 * This method initializes 
	 */
	public KSearchFrame(SearchController controller, Model model) {
		super();
		initialize(controller, model);
	}

	
	/**
	 * This method initializes this
	 */
	public void initialize(SearchController controller, Model model) {		
		this.controller = controller;
		this.model = model;		
		initialize();
		registerObservers(false);
	}
	
	
	/**
	 * Cleanup resources the frame is using.
	 */
	public void dispose() {
		try {
			removeObservers(false);
		} catch (Throwable ignore) {}
		super.dispose();
	}
	
	
	/**
	 * This method initializes this
	 */
	private void initialize()
	{
        this.setSize(new Dimension(623, 394));
        this.setContentPane(getJContentPane());
        this.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        setLocationRelativeTo(null);
        setTitle(getString("search.frame.title")); //  @jve        
        addWindowFocusListener(this);
	}
	
	
	/**
	 * This method initializes jContentPane	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	public JPanel getJContentPane() {
		if (jContentPane == null) {
			GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
			gridBagConstraints21.gridx = 1;
			gridBagConstraints21.fill = GridBagConstraints.HORIZONTAL;
			gridBagConstraints21.gridwidth = 1;
			gridBagConstraints21.weighty = 0.0;
			gridBagConstraints21.anchor = GridBagConstraints.SOUTH;
			gridBagConstraints21.gridy = 4;
			GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
			gridBagConstraints11.gridx = 0;
			gridBagConstraints11.fill = GridBagConstraints.HORIZONTAL;
			gridBagConstraints11.insets = new Insets(0, 10, 0, 10);
			gridBagConstraints11.gridy = 2;
			GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
			gridBagConstraints2.gridx = 1;
			gridBagConstraints2.fill = GridBagConstraints.HORIZONTAL;
			gridBagConstraints2.insets = new Insets(10, 10, 10, 10);
			gridBagConstraints2.gridy = 3;
			GridBagConstraints gridBagConstraints = new GridBagConstraints();
			gridBagConstraints.gridx = 1;
			gridBagConstraints.fill = GridBagConstraints.BOTH;
			gridBagConstraints.anchor = GridBagConstraints.NORTH;
			gridBagConstraints.weighty = 1.0;
			gridBagConstraints.weightx = 1.0;
			gridBagConstraints.insets = new Insets(10, 10, 0, 10);
			gridBagConstraints.gridy = 1;
			jContentPane = new JPanel();
			jContentPane.setLayout(new GridBagLayout());
			jContentPane.add(getMainPanel(), gridBagConstraints);
			jContentPane.add(getButtonPanel(), gridBagConstraints2);
			jContentPane.add(getStatusPanel(), gridBagConstraints21);
		}
		return jContentPane;
	}
	
	/**
	 * This method initializes statusLabel
	 * 
	 * @return javax.swing.JLabel
	 */
	private JLabel getStatusLabel() {
		if (statusLabel == null) {
			statusLabel = new JLabel(" ");
		}
		return statusLabel;
	}

	/**
	 * This method initializes mainPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getMainPanel() {
		if (mainPanel == null) {
			GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
			gridBagConstraints4.fill = GridBagConstraints.BOTH;
			gridBagConstraints4.weightx = 1.0;
			gridBagConstraints4.weighty = 1.0;
			gridBagConstraints4.anchor = GridBagConstraints.CENTER;
			GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
			gridBagConstraints5.gridx = -1;
			gridBagConstraints5.gridy = -1;
			GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
			gridBagConstraints1.fill = GridBagConstraints.NONE;
			gridBagConstraints1.weighty = 0.0;
			gridBagConstraints1.gridx = 0;
			gridBagConstraints1.gridy = 0;
			gridBagConstraints1.anchor = GridBagConstraints.WEST;
			gridBagConstraints1.weightx = 0.0;
			mainPanel = new JPanel();
			mainPanel.setLayout(new GridBagLayout());
			mainPanel.setBorder(BorderFactory.createEtchedBorder(EtchedBorder.LOWERED));
			mainPanel.add(getInputPanel(), gridBagConstraints4);
		}
		return mainPanel;
	}

	/**
	 * This method initializes buttonPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getButtonPanel() {
		if (buttonPanel == null) {
			GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
			gridBagConstraints3.anchor = GridBagConstraints.EAST;
			gridBagConstraints3.gridx = -1;
			gridBagConstraints3.gridy = -1;
			gridBagConstraints3.insets = new Insets(8, 5, 8, 5);
			buttonPanel = new JPanel();
			buttonPanel.setLayout(new FlowLayout(FlowLayout.TRAILING));
			buttonPanel.add(getSearchButton(), null);
			buttonPanel.add(getEditButton(), null);
			buttonPanel.add(getExportButton(), null);
			buttonPanel.add(getCloseButton(), null);
		}
		return buttonPanel;
	}

	/**
	 * This method initializes registerButton	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getSearchButton() {
		if (searchButton == null) {
			searchButton = new KSearchButton();			
			searchButton.setEnabled(false);
			searchButton.addActionListener(this);
			getRootPane().setDefaultButton(searchButton);
		}
		return searchButton;
	}

	/**
	 * This method initializes exitButton	
	 * 	
	 * @return org.ferris.journal.exit.ExitButton	
	 */
	private JButton getCloseButton() {
		if (closeButton == null) {
			closeButton = new KCloseButton();
			closeButton.addActionListener(this);
		}
		return closeButton;
	}

	/**
	 * This method initializes statusPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getStatusPanel() {
		if (statusPanel == null) {
			FlowLayout flowLayout = new FlowLayout();
			flowLayout.setHgap(0);
			flowLayout.setAlignment(java.awt.FlowLayout.LEFT);
			flowLayout.setVgap(0);
			statusLabel = getStatusLabel();			
			statusPanel = new JPanel();
			statusPanel.setLayout(flowLayout);
			statusPanel.setBorder(BorderFactory.createBevelBorder(BevelBorder.LOWERED));
			statusPanel.add(statusLabel, null);
		}
		return statusPanel;
	}	

	/**
	 * This method initializes inputPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getInputPanel() {
		if (inputPanel == null) {
			GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
			gridBagConstraints14.gridx = 1;
			gridBagConstraints14.fill = GridBagConstraints.BOTH;
			gridBagConstraints14.gridy = 1;
			GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
			gridBagConstraints13.gridx = 0;
			gridBagConstraints13.insets = new Insets(8, 5, 8, 5);
			gridBagConstraints13.gridy = 1;
			dateRangeLabel = new JLabel();
			dateRangeLabel.setText("Dates :");
			GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
			gridBagConstraints9.fill = GridBagConstraints.BOTH;
			gridBagConstraints9.gridy = 2;
			gridBagConstraints9.weightx = 1.0;
			gridBagConstraints9.weighty = 0.5;
			gridBagConstraints9.insets = new Insets(8, 5, 0, 5);
			gridBagConstraints9.anchor = GridBagConstraints.NORTH;
			gridBagConstraints9.gridx = 1;
			GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
			gridBagConstraints12.fill = GridBagConstraints.BOTH;
			gridBagConstraints12.gridy = 4;
			gridBagConstraints12.weightx = 1.0;
			gridBagConstraints12.weighty = 1.0;
			gridBagConstraints12.gridwidth = 2;
			gridBagConstraints12.anchor = GridBagConstraints.CENTER;
			gridBagConstraints12.gridx = 0;
			GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
			gridBagConstraints10.gridx = 0;
			gridBagConstraints10.weighty = 0.0;
			gridBagConstraints10.gridy = 3;
			spacer = new JLabel();
			spacer.setText("   ");
			GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
			gridBagConstraints8.gridx = 0;
			gridBagConstraints8.anchor = GridBagConstraints.NORTH;
			gridBagConstraints8.insets = new Insets(8, 5, 8, 5);
			gridBagConstraints8.weighty = 0.0;
			gridBagConstraints8.gridheight = 1;
			gridBagConstraints8.gridy = 2;
			journalListLabel = new JLabel();
			journalListLabel.setText("Journals :");
			GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
			gridBagConstraints7.fill = GridBagConstraints.HORIZONTAL;
			gridBagConstraints7.gridy = 0;
			gridBagConstraints7.weightx = 1.0;
			gridBagConstraints7.insets = new Insets(0, 5, 0, 5);
			gridBagConstraints7.gridx = 1;
			GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
			gridBagConstraints6.gridx = 0;
			gridBagConstraints6.anchor = GridBagConstraints.EAST;
			gridBagConstraints6.insets = new Insets(8, 5, 8, 5);
			gridBagConstraints6.gridy = 0;
			keywordLabel = new JLabel();
			keywordLabel.setText("Keyword :");
			inputPanel = new JPanel();
			inputPanel.setLayout(new GridBagLayout());
			inputPanel.add(keywordLabel, gridBagConstraints6);
			inputPanel.add(getKeywordText(), gridBagConstraints7);
			inputPanel.add(journalListLabel, gridBagConstraints8);
			inputPanel.add(spacer, gridBagConstraints10);
			inputPanel.add(getEntryTableScrollPane(), gridBagConstraints12);
			inputPanel.add(getJournalsScrollPane(), gridBagConstraints9);
			inputPanel.add(dateRangeLabel, gridBagConstraints13);
			inputPanel.add(getDateRangePanel(), gridBagConstraints14);
		}
		return inputPanel;
	}

	/**
	 * This method initializes keywordText	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private KKeywordTextField getKeywordText() {
		if (keywordText == null) {
			keywordText = new KKeywordTextField();
			keywordText.getDocument().addDocumentListener(this);
		}
		return keywordText;
	}

	/**
	 * This method initializes entryListScrollPane	
	 * 	
	 * @return javax.swing.JScrollPane	
	 */
	private JScrollPane getEntryTableScrollPane() {
		if (entryTableScrollPane == null) {
			entryTableScrollPane = new JScrollPane();
			entryTableScrollPane.setViewportView(getEntryTable());
		}
		return entryTableScrollPane;
	}


	/**
	 * This method initializes entryTable	
	 * 	
	 * @return org.ferris.journal.gui.view.table.KEntryTable	
	 */
	private KEntryTable getEntryTable() {
		if (entryTable == null) {
			entryTable = new KEntryTable(new KEntryTableModel(new ArrayList<JournalEntry>()));
			entryTable.addMouseListener(new MouseAdapter(){
			     public void mouseClicked(MouseEvent e){
			      if (e.getClickCount() == 2){
			         getEditButton().doClick();
			         }
			      }
			     } );
		}
		return entryTable;
	}


	/**
	 * This method initializes editButton	
	 * 	
	 * @return org.ferris.journal.gui.view.button.KEditButton	
	 */
	private KEditButton getEditButton() {
		if (editButton == null) {
			editButton = new KEditButton();
			editButton.setEnabled(true);
			editButton.addActionListener(this);
		}
		return editButton;
	}
	

	
	
	/////////////////////////////////////////////////////////////////
	//
	// WindowFocusListener
	//
	/////////////////////////////////////////////////////////////////	
	public void windowGainedFocus(WindowEvent e) {		
		registerObservers(true);
	}

	public void windowLostFocus(WindowEvent e) {
		removeObservers(true);		
	}
	
	
	
	
	/////////////////////////////////////////////////////////////////
	//
	// ReleaseObserver
	//
	/////////////////////////////////////////////////////////////////
	public void released() {
		log.info("ENTER: relase()");
		System.out.println("Are you sure you want to exit?");		
	}	
	
	
	
	
	/////////////////////////////////////////////////////////////////
	//
	// ActionListener
	//
	/////////////////////////////////////////////////////////////////	
	public void actionPerformed(ActionEvent evnt) 
	{
		if ("close".equals(evnt.getActionCommand())) 
		{
			controller.close();	
		}
		else
		if ("edit".equals(evnt.getActionCommand())) {
			JournalEntry selected
				= getEntryTable().getSelectedEntry();
			if (selected == null) {
				return;
			} else {
				controller.edit(selected);
			}
		}
		else
		if ("exportAsText".equals(evnt.getActionCommand()))
		{
			if (getEntryTable().getRowCount() > 0)
			{
				String lastDirectory
					= getPreference("exportSearchToDirectory");
				
				String lastFile
					= getPreference("exportSearchToFile");
				
				JFileChooser jfc
					= new JFileChooser(lastDirectory);
				
				if (lastFile != null) {
					jfc.setSelectedFile(new File(lastFile));
				}
				
				int jfcRes
					= jfc.showSaveDialog(this);
				
				if (JFileChooser.APPROVE_OPTION == jfcRes)
				{
					setPreference("exportSearchToDirectory", jfc.getSelectedFile().getParent());
					setPreference("exportSearchToFile", jfc.getSelectedFile().getName());
					
					controller.export(jfc.getSelectedFile(), getEntryTable().getEntryTableModel().getEntries());
				} else {
				}
			}
		}
		else
		if ("datePickerCommit".equals(evnt.getActionCommand())) {
			if (!getSearchButton().isEnabled()) {
				getSearchButton().setEnabled(true);
			}
		}
		else
		if ("search".equals(evnt.getActionCommand())) 
		{
			// Error check
			List<String>
				explainations = validateInput();
			
			if (!explainations.isEmpty())  {
				new KErrorDialog(this, explainations);
				return;
			}
			
			List<Journal> journals
				= getJournalList().getSelectedJournals();
			
			long [] journalIds = null;
			if (journals != null && !journals.isEmpty()) {
				journalIds = new long[journals.size()];
				int i=0; for(Journal j : journals) {
					journalIds[i++] = j.getId().longValue();
				}
			}
			
			Calendar min = null;
			if (getMinDateDatePicker().getDate() != null) {
				min = Calendar.getInstance();
				min.setTime(getMinDateDatePicker().getDate());
			}
			
			Calendar max = null;
			if (getMaxDateDatePicker().getDate() != null) {
				max = Calendar.getInstance();
				max.setTime(getMaxDateDatePicker().getDate());
			}
			
			controller.search(
				  getKeywordText().getText()
				, journalIds
				, min
				, max
			);
		}
		else
		{
			new ThrowableDialog(
				  new RuntimeException(
				   	  getString("exception.actioncommand.not.recognized", evnt.getActionCommand()) //  @jve 
				  )
				, false
			);
		}
	}	
	
	
	
		
	/////////////////////////////////////////////////////////////////
	//
	// DocumentListener
	//
	/////////////////////////////////////////////////////////////////
	public void changedUpdate(DocumentEvent e) {
		if (!getSearchButton().isEnabled()) {			
			getSearchButton().setEnabled(true);
		}
	}
	public void removeUpdate(DocumentEvent e) {
		if (!getSearchButton().isEnabled()) {			
			getSearchButton().setEnabled(true);
		}
	}
	public void insertUpdate(DocumentEvent e) {
		if (!getSearchButton().isEnabled()) {			
			getSearchButton().setEnabled(true);
		}
	}
	
	
	
	
	/////////////////////////////////////////////////////////////////
	//
	// ItemListener
	//
	/////////////////////////////////////////////////////////////////	
	public void itemStateChanged(ItemEvent e) 
	{
		switch (e.getStateChange()) {
		case ItemEvent.DESELECTED:
		case ItemEvent.SELECTED:
			log.info("*** Enable save: itemStateChanged");
			if (!getSearchButton().isEnabled()) {				
				getSearchButton().setEnabled(true);
			}
			break;
		default:
			break;
		}
	}
	
	
	
	
	/////////////////////////////////////////////////////////////////
	//
	// OperationObserver
	//
	/////////////////////////////////////////////////////////////////		
	public void performingOperation(final String description) {
		InvokeAndWait.run(
				new Runnable() {
					public void run() {
						getStatusLabel().setText(description);
					}
				}
			);
	}
	
	
	
	
	/////////////////////////////////////////////////////////////////
	//
	// ----------------------- Helpers ------------------------------
	//
	/////////////////////////////////////////////////////////////////
	private void registerObservers(boolean focusChange) {
		if (!focusChange) {
			this.model.registerObserver((ReleaseObserver)this);
			this.model.registerObserver((OperationObserver)this);
			this.model.registerObserver((JournalEntrySearchObserver)this);
			this.model.registerObserver((JournalEntryObserver)this);
		} else {
			this.model.registerObserver((OperationObserver)this);
			this.model.registerObserver((JournalEntrySearchObserver)this);
		}
	}
	private void removeObservers(boolean focusChange) {
		if (!focusChange) {
			this.model.removeObserver((ReleaseObserver)this);		
			this.model.removeObserver((OperationObserver)this);
			this.model.removeObserver((JournalEntrySearchObserver)this);
			this.model.removeObserver((JournalEntryObserver)this);
		} else {
			this.model.removeObserver((OperationObserver)this);
			this.model.removeObserver((JournalEntrySearchObserver)this);
		}
	}
	private List<String> validateInput() {
		// Error check
		List<String> explainations 
			= new ArrayList<String>();
		
		getKeywordText().validate(explainations);
		
		if (getMinDateDatePicker().getDate() != null && getMaxDateDatePicker().getDate() != null) {
			if (getMinDateDatePicker().getDate().getTime() > getMaxDateDatePicker().getDate().getTime()) {
				explainations.add(getString("search.date.malformed.mingtmax"));
			}
		}
		
		if (explainations.isEmpty())
		{
			List<Journal> journals
				= getJournalList().getSelectedJournals();
			
			
			boolean missing = (
				getKeywordText().getText().length() == 0
				&&
				journals.size() == 0
				&&
				getMinDateDatePicker().getDate() == null
				&&
				getMaxDateDatePicker().getDate() == null
			);
			
			if (missing) {
				explainations.add(getString("search.malformed.required"));
			}
		}
		
		return explainations;
	}
	private String getPreference(String key)
	{
		String pref
			= prefs.get("KSearchFrame." + key, null);
		return pref;
	}
	private void setPreference(String key, String pref)
	{
		prefs.put("KSearchFrame." + key, pref);
		try {
			prefs.flush();
		} catch (Exception e) {
			throw new RuntimeException(e.getMessage(),e);
		}
	}	


	
	/////////////////////////////////////////////////////////////////
	//
	// JournalEntrySearchObserver
	//
	/////////////////////////////////////////////////////////////////
	public void results(List<JournalEntry> results) 
	{
		Collections.sort(results, JournalEntryComparator.DAY_ASC);
		getEntryTable().setEntries(results);	
		getKeywordText().setSelectionStart(0);
		getKeywordText().setSelectionEnd(getKeywordText().getText().length());
		getKeywordText().grabFocus();
	}
	
	
	
	/////////////////////////////////////////////////////////////////
	//
	// JournalEntryObserver
	//
	/////////////////////////////////////////////////////////////////	
	public void deletedJournalEntry(JournalEntry deletedJournal) 
	{
		getEntryTable().deleteEntry(deletedJournal);
		getStatusLabel().setText(
			getString("op.search.found", getEntryTable().getRowCount())
		);
	}
	public void editJournalEntry(JournalEntry editMe) {
	}
	public void insertedJournalEntry(JournalEntry newJournal) 
	{	
		String s = getKeywordText().getText();
		if (s == null) s = "";
		if (s != null) s = s.trim();		
		if (s.length() > 0) 
		{
			String keywordUppercase = getKeywordText().getText().toUpperCase();
			boolean contains = (
				newJournal.getSubject().toUpperCase().contains(keywordUppercase)
				||
				newJournal.getEntry().toUpperCase().contains(keywordUppercase)
			);
			if (contains) { 
				getEntryTable().addEntry(newJournal);
				getStatusLabel().setText(
					getString("op.search.found", getEntryTable().getRowCount())
				);
			}
		}
	}
	public void newJournalEntry() {
	}
	public void updatedJournalEntry(JournalEntry updatedJournal) {
		getEntryTable().updateEntry(updatedJournal);
	}


	/**
	 * This method initializes exportButton	
	 * 	
	 * @return org.ferris.journal.gui.view.button.KExportAsTextButton	
	 */
	private KExportAsTextButton getExportButton() {
		if (exportButton == null) {
			exportButton = new KExportAsTextButton();
			exportButton.setEnabled(true);
			exportButton.addActionListener(this);
		}
		return exportButton;
	}


	/**
	 * This method initializes journalsScrollPane	
	 * 	
	 * @return javax.swing.JScrollPane	
	 */
	private JScrollPane getJournalsScrollPane() {
		if (journalsScrollPane == null) {
			journalsScrollPane = new JScrollPane();		
			journalsScrollPane.setViewportView(getJournalList());
		}
		return journalsScrollPane;
	}


	/**
	 * This method initializes journalList	
	 * 	
	 * @return org.ferris.journal.gui.view.list.KJournalList	
	 */
	private KJournalList getJournalList() {
		if (journalList == null) {
			if (this.model == null) { 
				this.model = new ModelForVisualEditor();
			}
			journalList = new KJournalList(
				new KJournalListModelForAllJournals(model)
			);
			journalList.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
			journalList.addKeyListener(
				new KeyListener() {
					public void keyPressed(KeyEvent e) {
						if (e.getKeyCode() == KeyEvent.VK_ESCAPE) {
							journalList.clearSelection();
						}						
					}
					public void keyReleased(KeyEvent e) {
					}
					public void keyTyped(KeyEvent e) {
					}
				}
			);
			journalList.addListSelectionListener(
				new ListSelectionListener() {
					public void valueChanged(ListSelectionEvent e) {						
						if (!e.getValueIsAdjusting()) {
							if (!getSearchButton().isEnabled()) {
								getSearchButton().setEnabled(
									journalList.getSelectedJournals().size() > 0
								);
							}
						}
					}
				}
			);
		}
		return journalList;
	}


	/**
	 * This method initializes dateRangePanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getDateRangePanel() {
		if (dateRangePanel == null) {
			FlowLayout flowLayout1 = new FlowLayout(FlowLayout.LEFT);
			flowLayout1.setVgap(5);
			toLabel = new JLabel();
			toLabel.setText("to");
			dateRangePanel = new JPanel();
			dateRangePanel.setLayout(flowLayout1);
			dateRangePanel.add(getMinDateDatePicker(), null);
			dateRangePanel.add(toLabel, null);
			dateRangePanel.add(getMaxDateDatePicker(), null);
		}
		return dateRangePanel;
	}


	/**
	 * This method initializes minDateDatePicker	
	 * 	
	 * @return org.ferris.journal.gui.view.datepicker.KEntryDateDatePicker	
	 */
	private KEntryDateDatePicker getMinDateDatePicker() {
		if (minDateDatePicker == null) {
			minDateDatePicker = new KEntryDateDatePicker();
			minDateDatePicker.getEditor().getDocument().addDocumentListener(this);
			minDateDatePicker.addActionListener(this);
		}
		return minDateDatePicker;
	}


	/**
	 * This method initializes maxDateDatePicker	
	 * 	
	 * @return org.ferris.journal.gui.view.datepicker.KEntryDateDatePicker	
	 */
	private KEntryDateDatePicker getMaxDateDatePicker() {
		if (maxDateDatePicker == null) {
			maxDateDatePicker = new KEntryDateDatePicker();
			maxDateDatePicker.getEditor().getDocument().addDocumentListener(this);
			maxDateDatePicker.addActionListener(this);
		}
		return maxDateDatePicker;
	}


}  //  @jve:decl-index=0:visual-constraint="56,4"
