package org.ferris.journal.gui.view.list;

import java.util.List;

import javax.swing.DefaultListModel;

import org.apache.log4j.Logger;
import org.ferris.journal.gui.model.JournalObserver;
import org.ferris.journal.jws.journal.Journal;

public abstract class KAbstractJournalListModel extends DefaultListModel 
//implements JournalObserver
{
	private void journalChanged(Journal journal) {
		int newSelectedIndex =
			getJournals().indexOf(journal);
		
		fireContentsChanged(this, newSelectedIndex, newSelectedIndex);	
	}
	
	
	
	private static final long serialVersionUID = -8119364852579022667L;
	private Logger log = Logger.getLogger(getClass());
	
	public abstract List<Journal> getJournals() ;
	
	public Object getElementAt(int index) {
		return getJournalAt(index);
	}
	
	public Journal getJournalAt(int index) {
		return getJournals().get(index);
	}

	public int getSize() {
		return getJournals().size();
	}

	public int getIndexOf(Journal j) {
		return getJournals().indexOf(j);
	}

/////////////////////////////////////////////////////////////////////
// JournalObserver
/////////////////////////////////////////////////////////////////////
	
	public void insertedJournal(Journal newJournal) 
	{		
		log.info("ENTER: insertedJournal()");
		journalChanged(newJournal);
		log.info("EXIT: insertedJournal()");
	}

	public void deletedJournal(Journal deletedJournl) {
		fireContentsChanged(this, 0, getJournals().size());
	}

	public void updatedJournal(Journal updatedJournal) {
		log.info("ENTER: updatedJournal()");
		journalChanged(updatedJournal);
		log.info("EXIT: updatedJournal()");
	}

	public void editJournal(Journal editMe) {
	}

	public void newJournal() {
	}

}
