/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.journal.gui.controller;

import java.awt.Container;
import java.util.ArrayList;
import javax.swing.JComponent;
import org.apache.commons.codec.binary.Base64;
import org.ferris.awt.ContainerTools;
import org.ferris.crypto.Blowfish;
import org.ferris.crypto.KeyMaterialLocator;
import org.ferris.journal.gui.controller.EntryController;
import org.ferris.journal.gui.crypto.KeyMaterialLocatorForBlowfish;
import org.ferris.journal.gui.data.AccountData;
import org.ferris.journal.gui.i18n.i18n;
import org.ferris.journal.gui.model.Model;
import org.ferris.journal.gui.view.dialog.KErrorDialog;
import org.ferris.journal.gui.view.frame.KLoginFrame;
import org.ferris.journal.jws.account.Account;
import org.ferris.swing.JComponentTools;

public class LoginController {
    private Model model;
    private KLoginFrame view;

    private LoginController setModel(Model model) {
        this.model = model;
        return this;
    }

    private Model getModel() {
        return this.model;
    }

    private LoginController setView() {
        this.view = new KLoginFrame(this, this.getModel());
        return this;
    }

    private KLoginFrame getView() {
        return this.view;
    }

    public LoginController(Model model) {
        this.setModel(model).setView().getView().setVisible(true);
    }

    public void exit() {
        this.getModel().release();
    }

    public void disposeView() {
        if (this.getView() != null && this.getView().isVisible()) {
            this.getView().setVisible(false);
            this.getView().dispose();
        }
    }

    public void login(final String username, final char[] unencryptedPassword) {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ContainerTools.setEnabled((Container)LoginController.this.view.getJContentPane(), (boolean)false);
                    JComponentTools.setWaitCursor((JComponent)LoginController.this.view.getJContentPane());
                    LoginController.this.model.performingOperation(i18n.getString("op.newAccount", new Object[0]));
                    Account a = new Account();
                    LoginController.this.model.performingOperation(i18n.getString("op.setUsername", new Object[0]));
                    a.setUsername(username);
                    LoginController.this.model.performingOperation(i18n.getString("op.setPassword", new Object[0]));
                    a.setPassword(new String(Base64.encodeBase64((byte[])new Blowfish((KeyMaterialLocator)new KeyMaterialLocatorForBlowfish()).encrypt(new String(unencryptedPassword)))));
                    LoginController.this.model.performingOperation(i18n.getString("op.login", new Object[0]));
                    a = AccountData.getInstance().login(a);
                    if (a == null) {
                        LoginController.this.model.performingOperation(i18n.getString("op.loginFailed", new Object[0]));
                        ArrayList<String> errors = new ArrayList<String>();
                        errors.add(i18n.getString("loginFailed", new Object[0]));
                        new KErrorDialog(LoginController.this.view, errors);
                    } else {
                        LoginController.this.model.setAccount(a);
                        LoginController.this.view.setVisible(false);
                        LoginController.this.view.dispose();
                        new EntryController(LoginController.this.getModel());
                    }
                }
                finally {
                    ContainerTools.setEnabled((Container)LoginController.this.view.getJContentPane(), (boolean)true);
                    JComponentTools.setDefaultCursor((JComponent)LoginController.this.view.getJContentPane());
                }
            }
        }.start();
    }

    public void register(final String username, final char[] unencryptedPassword) {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ContainerTools.setEnabled((Container)LoginController.this.view.getJContentPane(), (boolean)false);
                    JComponentTools.setWaitCursor((JComponent)LoginController.this.view.getJContentPane());
                    LoginController.this.model.performingOperation(i18n.getString("op.newAccount", new Object[0]));
                    Account a = new Account();
                    LoginController.this.model.performingOperation(i18n.getString("op.setUsername", new Object[0]));
                    a.setUsername(username);
                    LoginController.this.model.performingOperation(i18n.getString("op.setPassword", new Object[0]));
                    a.setPassword(new String(Base64.encodeBase64((byte[])new Blowfish((KeyMaterialLocator)new KeyMaterialLocatorForBlowfish()).encrypt(new String(unencryptedPassword)))));
                    LoginController.this.model.performingOperation(i18n.getString("op.register", new Object[0]));
                    a = AccountData.getInstance().register(a);
                    if (a == null) {
                        LoginController.this.model.performingOperation(i18n.getString("op.registerFailed", new Object[0]));
                        ArrayList<String> errors = new ArrayList<String>();
                        errors.add(i18n.getString("registerFailed", new Object[0]));
                        new KErrorDialog(LoginController.this.view, errors);
                    } else {
                        LoginController.this.model.setAccount(a);
                        LoginController.this.view.setVisible(false);
                        LoginController.this.view.dispose();
                        new EntryController(LoginController.this.getModel());
                    }
                }
                finally {
                    ContainerTools.setEnabled((Container)LoginController.this.view.getJContentPane(), (boolean)true);
                    JComponentTools.setDefaultCursor((JComponent)LoginController.this.view.getJContentPane());
                }
            }
        }.start();
    }
}

