/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.journal.gui.view.table;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.DefaultTableModel;
import org.ferris.journal.gui.i18n.i18n;
import org.ferris.journal.jws.journalentry.JournalEntry;

public class KEntryTableModel
extends DefaultTableModel {
    private static final long serialVersionUID = -7213920218024889576L;
    private static List<JournalEntry> empty = new ArrayList<JournalEntry>(0);
    private static SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy");
    private List<JournalEntry> entries;

    private int indexOf(JournalEntry e) {
        int idx = -1;
        for (JournalEntry entry : this.getEntries()) {
            ++idx;
            if (!entry.getId().equals(e.getId())) continue;
            return idx;
        }
        return -1;
    }

    public List<JournalEntry> getEntries() {
        if (this.entries == null) {
            return empty;
        }
        return this.entries;
    }

    public void setEntries(List<JournalEntry> newEntries) {
        if (this.entries != null) {
            this.entries.clear();
        }
        this.entries = new ArrayList<JournalEntry>(newEntries.size());
        this.entries.addAll(newEntries);
        this.fireTableDataChanged();
    }

    public KEntryTableModel(List<JournalEntry> entries) {
        this.setEntries(entries);
        this.addColumn(i18n.getString("column.day", new Object[0]));
        this.addColumn(i18n.getString("column.journal", new Object[0]));
        this.addColumn(i18n.getString("column.subject", new Object[0]));
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        return this.getEntries().size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        JournalEntry entry = this.getEntries().get(row);
        switch (column) {
            case 0: {
                return simpleDateFormat.format(entry.getDay().getTime());
            }
            case 1: {
                return entry.getJournal().getName();
            }
            case 2: {
                return entry.getSubject();
            }
        }
        throw new RuntimeException("Table row: \"" + row + "\" column: \"" + column + "\" for journal entry list is not understood.");
    }

    public int deleteEntry(JournalEntry deletedJournal) {
        int idx = this.indexOf(deletedJournal);
        if (idx != -1) {
            this.getEntries().remove(idx);
            this.fireTableDataChanged();
        }
        return idx;
    }

    public int addEntry(JournalEntry newJournal) {
        this.getEntries().add(newJournal);
        this.fireTableDataChanged();
        return this.getEntries().size() - 1;
    }

    public int updateEntry(JournalEntry updatedJournal) {
        int idx = this.indexOf(updatedJournal);
        if (idx != -1) {
            this.getEntries().remove(idx);
            this.getEntries().add(idx, updatedJournal);
            this.fireTableDataChanged();
        }
        return idx;
    }
}

