/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.journal.gui.view.textfield;

import org.ferris.constraint.Check;
import org.ferris.constraint.Constraint;
import org.ferris.constraint.NotNull;
import org.ferris.constraint.StringLengthBetween;
import org.ferris.constraint.StringPattern;
import org.ferris.journal.gui.i18n.i18n;
import org.ferris.journal.gui.view.textfield.KAbstractTextField;
import org.ferris.util.regex.EmailPattern;

public class KEmailTextField
extends KAbstractTextField {
    private static final long serialVersionUID = -352120234314107743L;
    private Constraint<String> constraint;

    private int getMin() {
        return 0;
    }

    private int getMax() {
        return 50;
    }

    @Override
    public Constraint<String> getConstraint() {
        if (this.constraint == null) {
            this.constraint = new NotNull((Constraint)new StringLengthBetween(this.getMin(), false, this.getMax(), true, (Constraint)new StringPattern(EmailPattern.PATTERN)));
        }
        return this.constraint;
    }

    @Override
    public String getExplaination(Check check) {
        if (check.equals((Object)Check.IsNull)) {
            return i18n.getString("email.malformed.null", new Object[0]);
        }
        if (check.equals((Object)Check.EqualToMin)) {
            return i18n.getString("email.malformed.tooshort", new Object[0]);
        }
        if (check.equals((Object)Check.GreaterThan)) {
            return i18n.getString("email.malformed.toolong", this.getMax(), this.getText().length());
        }
        if (check.equals((Object)Check.NoMatch)) {
            return i18n.getString("email.malformed.wrongpattern", new Object[0]);
        }
        throw new RuntimeException(i18n.getString("exception.check.not.recognized", check));
    }
}

