/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.constraint;

import org.ferris.constraint.Check;
import org.ferris.constraint.Constraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Between<N extends Comparable>
implements Constraint<N> {
    private Constraint<N> next;
    private Comparable<N> min;
    private boolean minInclusive;
    private Comparable<N> max;
    private boolean maxInclusive;

    public Between(Comparable<N> min, Comparable<N> max) {
        this.init(min, true, max, true, null);
    }

    public Between(Comparable<N> min, Comparable<N> max, Constraint<N> next) {
        this.init(min, true, max, true, next);
    }

    public Between(Comparable<N> min, boolean minInclusive, Comparable<N> max, boolean maxInclusive) {
        this.init(min, minInclusive, max, maxInclusive, null);
    }

    public Between(Comparable<N> min, boolean minInclusive, Comparable<N> max, boolean maxInclusive, Constraint<N> next) {
        this.init(min, minInclusive, max, maxInclusive, null);
    }

    private void init(Comparable<N> min, boolean minInclusive, Comparable<N> max, boolean maxInclusive, Constraint<N> next) {
        this.min = min;
        this.minInclusive = minInclusive;
        this.max = max;
        this.maxInclusive = maxInclusive;
        this.next = next;
    }

    @Override
    public Check check(N checkMe) {
        if (checkMe != null) {
            int n = checkMe.compareTo(this.min);
            int x = checkMe.compareTo(this.max);
            if (this.minInclusive) {
                if (n < 0) {
                    return Check.LessThan;
                }
            } else {
                if (n < 0) {
                    return Check.LessThan;
                }
                if (n == 0) {
                    return Check.EqualToMin;
                }
            }
            if (this.maxInclusive) {
                if (x > 0) {
                    return Check.GreaterThan;
                }
            } else {
                if (x > 0) {
                    return Check.GreaterThan;
                }
                if (x == 0) {
                    return Check.EqualToMax;
                }
            }
        }
        return this.next == null ? null : this.next.check(checkMe);
    }
}

