/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.swing;

import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import org.apache.log4j.Logger;

public class JCaretPositionLabel
extends JLabel
implements CaretListener {
    private static final long serialVersionUID = 5700486779761593192L;
    private static final ResourceBundle rb = ResourceBundle.getBundle(JCaretPositionLabel.class.getName());
    private Logger log = Logger.getLogger(this.getClass());
    private int headerLineCount;
    private int bodyLineCount;

    private int getHeaderLineCount() {
        return this.headerLineCount;
    }

    private int getBodyLineCount() {
        return this.bodyLineCount;
    }

    private void setText(int row, int col) {
        this.setText(rb.getString("row") + " " + row + " " + rb.getString("seperator") + " " + this.getBodyLineCount() + "    " + rb.getString("column") + " " + col);
    }

    public void caretUpdate(CaretEvent evnt) {
        new SetTextThread(evnt).start();
    }

    public void setHeaderLineCount(int headerLineCount) {
        this.headerLineCount = headerLineCount;
    }

    public void setBodyLineCount(int bodyLineCount) {
        this.bodyLineCount = bodyLineCount;
    }

    public JCaretPositionLabel(int headerLineCount, int bodyLineCount) {
        this.setHeaderLineCount(headerLineCount);
        this.setBodyLineCount(bodyLineCount);
        new Thread(){

            public void run() {
                if (JCaretPositionLabel.this.getHeaderLineCount() > 0) {
                    JCaretPositionLabel.this.setText(0, 1);
                } else {
                    JCaretPositionLabel.this.setText(1, 1);
                }
            }
        }.start();
    }

    class SetTextThread
    extends Thread {
        private CaretEvent evnt;

        private SetTextThread(CaretEvent evnt) {
            this.evnt = evnt;
        }

        public void run() {
            JTextArea jta = (JTextArea)this.evnt.getSource();
            int pos = this.evnt.getDot();
            try {
                int row = jta.getLineOfOffset(pos) + 1;
                if (row <= JCaretPositionLabel.this.getHeaderLineCount()) {
                    row = 0;
                }
                if (row > JCaretPositionLabel.this.getHeaderLineCount()) {
                    row -= JCaretPositionLabel.this.getHeaderLineCount();
                }
                int col = pos - jta.getLineStartOffset(jta.getLineOfOffset(pos) + 1 - 1) + 1;
                JCaretPositionLabel.this.setText(row, col);
            }
            catch (BadLocationException e) {
                JCaretPositionLabel.this.log.fatal((Object)"BadLocationException", (Throwable)e);
            }
        }
    }
}

