/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.swing;

import java.awt.Color;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.ferris.swing.ui.ThrowableDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JComponentErrors {
    private static final ResourceBundle rb = ResourceBundle.getBundle(JComponentErrors.class.getName());
    private LinkedList<JComponent> components;
    private LinkedList<String> messages;
    private LinkedList<Color> colors;

    private static String getString(String key, Object ... arguments) {
        String pattern = rb.getString(key);
        if (arguments != null && arguments.length > 0) {
            pattern = MessageFormat.format(pattern, arguments);
        }
        return pattern;
    }

    private LinkedList<String> getMessages() {
        if (this.messages == null) {
            this.messages = new LinkedList();
        }
        return this.messages;
    }

    private LinkedList<JComponent> getComponents() {
        if (this.components == null) {
            this.components = new LinkedList();
        }
        return this.components;
    }

    private LinkedList<Color> getColors() {
        if (this.colors == null) {
            this.colors = new LinkedList();
        }
        return this.colors;
    }

    public void addError(JComponent component, String message) {
        this.getComponents().add(component);
        this.getMessages().add(message);
        this.getColors().add(component.getBackground());
    }

    public void addError(JComponent[] componentArray, String message) {
        this.getComponents().add(new JComponentDecorator(componentArray));
        this.getMessages().add(message);
        this.getColors().add(Color.white);
    }

    public void addNumericError(JTextField text, String field) {
        text.setText(text.getText().trim());
        if (text.getText().length() > 0) {
            try {
                Double.parseDouble(text.getText());
            }
            catch (NumberFormatException e) {
                this.addError(text, field + " " + JComponentErrors.getString("numericError", new Object[0]));
            }
        }
    }

    public void addRequiredError(JTextField f1, String n1, JTextField f2, String n2) {
        f1.setText(f1.getText().trim());
        f2.setText(f2.getText().trim());
        if (f1.getText().length() > 0 && f2.getText().length() == 0) {
            this.addError(f2, n2 + " " + JComponentErrors.getString("requiredError", new Object[0]));
        }
        if (f2.getText().length() > 0 && f1.getText().length() == 0) {
            this.addError(f1, n1 + " " + JComponentErrors.getString("requiredError", new Object[0]));
        }
    }

    public void addRequiredError(JTextField[] fields, String message) {
        int length = 0;
        for (int i = 0; i < fields.length; ++i) {
            length += fields[i].getText().length();
        }
        if (length == 0) {
            this.addError(fields, message + " " + JComponentErrors.getString("requiredError", new Object[0]));
        }
    }

    public void addRequiredError(ButtonGroup bg, String message) {
        boolean selected = false;
        Enumeration<AbstractButton> enu = bg.getElements();
        while (!selected && enu.hasMoreElements()) {
            selected = ((JRadioButton)enu.nextElement()).isSelected();
        }
        if (!selected) {
            JComponent[] arry = new JComponent[bg.getButtonCount()];
            int i = 0;
            Enumeration<AbstractButton> enu2 = bg.getElements();
            while (!selected && enu2.hasMoreElements()) {
                arry[i++] = (JRadioButton)enu2.nextElement();
            }
            this.addError(arry, message + " " + JComponentErrors.getString("requiredError", new Object[0]));
        }
    }

    public void addRequiredError(JTextField f1, String n1) {
        f1.setText(f1.getText().trim());
        if (f1.getText().length() == 0) {
            this.addError(f1, n1 + " " + JComponentErrors.getString("requiredError", new Object[0]));
        }
    }

    public void addMinimumValueError(JTextField f1, JTextField f2, String name) {
        if (f1.getText().length() > 0 && f2.getText().length() > 0) {
            try {
                double d1 = Double.parseDouble(f1.getText());
                double d2 = Double.parseDouble(f2.getText());
                if (d1 > d2) {
                    this.addError(f1, name + " " + JComponentErrors.getString("minimumValueError", new Object[0]) + " " + f2.getText());
                }
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        }
    }

    public void addNoMoreThanGigahertzError(JTextField f1, JTextField f2, String name) {
        if (f1.getText().length() > 0 && f2.getText().length() > 0) {
            try {
                double d1 = Double.parseDouble(f1.getText());
                double d2 = Double.parseDouble(f2.getText());
                if (d1 - d2 > 1000.0) {
                    this.addError(f1, name + " " + JComponentErrors.getString("minimumValueError", new Object[0]) + " " + f2.getText());
                }
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        }
    }

    public boolean isEmpty() {
        return this.getComponents().isEmpty();
    }

    public void displayText() {
        new ErrorBackgroundColorThread().start();
        StringBuilder sp = new StringBuilder();
        sp.append(JComponentErrors.getString("heading1", new Object[0]));
        sp.append("\n");
        sp.append("\n");
        for (String comp : this.getMessages()) {
            sp.append("   ");
            sp.append(JComponentErrors.getString("bullet", new Object[0]));
            sp.append(" ");
            sp.append(comp);
            sp.append("\n");
        }
        JOptionPane.showOptionDialog(this.getParent(), sp.toString(), JComponentErrors.getString("title", new Object[0]), -1, 0, null, new String[]{JComponentErrors.getString("ok", new Object[0])}, JComponentErrors.getString("ok", new Object[0]));
    }

    public void displayHtml() {
        new ErrorBackgroundColorThread().start();
        StringBuilder sp = new StringBuilder();
        sp.append("<html>");
        sp.append("<body>");
        sp.append("<p>").append(JComponentErrors.getString("heading1", new Object[0])).append("</p>");
        sp.append("<br>");
        sp.append("<table>");
        for (String comp : this.getMessages()) {
            sp.append("<tr>");
            sp.append("<td>");
            sp.append("&nbsp;").append(JComponentErrors.getString("bullet", new Object[0])).append("&nbsp;");
            sp.append("</td>");
            sp.append("<td>");
            sp.append(comp);
            sp.append("</td>");
            sp.append("</tr>");
        }
        sp.append("</table>");
        sp.append("</body>");
        sp.append("</html>");
        JOptionPane.showOptionDialog(this.getParent(), new JLabel(sp.toString()), JComponentErrors.getString("title", new Object[0]), -1, 0, null, new String[]{JComponentErrors.getString("ok", new Object[0])}, JComponentErrors.getString("ok", new Object[0]));
    }

    public void clear() {
        NormalColorBackgroundThread t = new NormalColorBackgroundThread();
        ((Thread)t).run();
        try {
            t.join();
        }
        catch (InterruptedException e) {
            new ThrowableDialog(e, true);
        }
        this.getComponents().clear();
        this.getMessages().clear();
        this.getColors().clear();
    }

    public abstract Component getParent();

    public class ErrorBackgroundColorThread
    extends Thread {
        public void run() {
            for (int i = 0; i < JComponentErrors.this.getComponents().size(); ++i) {
                JComponent comp = (JComponent)JComponentErrors.this.getComponents().get(i);
                comp.setBackground(Color.red);
            }
        }
    }

    public class NormalColorBackgroundThread
    extends Thread {
        public void run() {
            for (int i = 0; i < JComponentErrors.this.getComponents().size(); ++i) {
                JComponent comp = (JComponent)JComponentErrors.this.getComponents().get(i);
                comp.setBackground((Color)JComponentErrors.this.getColors().get(i));
            }
        }
    }

    private class JComponentDecorator
    extends JComponent {
        private static final long serialVersionUID = 2417109780955678428L;
        private JComponent[] componentArray;
        private Color[] colors;

        public JComponentDecorator(JComponent[] componentArray) {
            this.componentArray = componentArray;
            this.colors = new Color[componentArray.length];
            for (int i = 0; i < componentArray.length; ++i) {
                this.colors[i] = componentArray[i].getBackground();
            }
        }

        public void setBackground(Color color) {
            if (color.equals(Color.red)) {
                for (int i = 0; i < this.componentArray.length; ++i) {
                    this.componentArray[i].setBackground(color);
                }
            } else {
                for (int i = 0; i < this.componentArray.length; ++i) {
                    this.componentArray[i].setBackground(this.colors[i]);
                }
            }
        }
    }
}

