/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.swing.text;

import java.util.Iterator;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.apache.log4j.Logger;
import org.ferris.swing.text.AppendDocumentBody;
import org.ferris.swing.text.AppendDocumentHeader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppendDocument
extends PlainDocument {
    private static final long serialVersionUID = 1203479283749027568L;
    private Logger log = Logger.getLogger(this.getClass());
    private AppendDocumentHeader header;
    private Iterator<? extends Object> headerIterator;
    private AppendDocumentBody body;
    private Iterator<? extends Object> bodyIterator;
    private int appendLineCount;

    private boolean append(Iterator<? extends Object> itr, int lineCount) {
        String method = "append(Iterator<? extends Object>, int)";
        this.log.info((Object)("ENTER " + method));
        try {
            int i;
            if (!itr.hasNext()) {
                this.log.info((Object)"No more data to append");
                return false;
            }
            if (this.getLength() > 0) {
                this.nl();
            }
            boolean appendAll = lineCount == Integer.MAX_VALUE;
            for (i = 1; i <= lineCount && itr.hasNext(); ++i) {
                this.append(itr.next());
                if (appendAll) {
                    if (!itr.hasNext()) continue;
                    this.nl();
                    continue;
                }
                if (i == lineCount) continue;
                this.nl();
            }
            this.log.info((Object)("Appended " + --i + " lines"));
            return true;
        }
        catch (BadLocationException e) {
            this.log.fatal((Object)"BadLocationException", (Throwable)e);
            throw new RuntimeException("A BadLocationException was caught in the " + method + " method of " + this.getClass().getName() + ". The" + " message of the exception is: " + e.getMessage(), e);
        }
    }

    private void nl() throws BadLocationException {
        this.insertString(this.getLength(), "\n", null);
    }

    private void append(Object o) throws BadLocationException {
        this.insertString(this.getLength(), String.valueOf(o), null);
    }

    private void clear() {
        try {
            this.replace(0, this.getLength(), "", null);
        }
        catch (BadLocationException e) {
            this.log.fatal((Object)"BadLocationException caught and rethrown as RuntimeException", (Throwable)e);
            throw new RuntimeException("A BadLocationException was caught in the clear() method of " + this.getClass().getName() + ". The" + " message of the exception is: " + e.getMessage(), e);
        }
    }

    private void set(AppendDocumentHeader header, AppendDocumentBody body, int appendLineCount) {
        this.setHeader(header);
        this.setBody(body);
        this.setAppendLineCount(appendLineCount);
        this.append(this.getHeaderIterator(), this.getHeader().getLineCount());
    }

    private void setHeader(AppendDocumentHeader header) {
        if (header == null) {
            this.log.fatal((Object)"The header parameter is null");
            throw new IllegalArgumentException("Method setHeader() of " + this.getClass().getName() + " says," + " the AppendDocumentHeader parameter is null.");
        }
        this.header = null;
        this.headerIterator = null;
        this.header = header;
    }

    private Iterator<? extends Object> getHeaderIterator() {
        if (this.headerIterator == null) {
            this.headerIterator = this.getHeader().getIterator();
        }
        return this.headerIterator;
    }

    private void setBody(AppendDocumentBody body) {
        if (body == null) {
            this.log.fatal((Object)"The body parameter is null");
            throw new IllegalArgumentException("Method setBody() of " + this.getClass().getName() + " says," + " the AppendDocumentBody parameter is null.");
        }
        this.body = null;
        this.bodyIterator = null;
        this.body = body;
    }

    private Iterator<? extends Object> getBodyIterator() {
        if (this.bodyIterator == null) {
            this.bodyIterator = this.getBody().getIterator();
        }
        return this.bodyIterator;
    }

    private void setAppendLineCount(int appendLineCount) {
        this.appendLineCount = appendLineCount;
    }

    public AppendDocument(AppendDocumentHeader header, AppendDocumentBody body, int appendLineCount) {
        this.set(header, body, appendLineCount);
    }

    public void dispose() {
        this.log.info((Object)"ENTER dispose()");
        this.getHeader().dispose();
        this.getBody().dispose();
    }

    public void reset(AppendDocumentHeader header, AppendDocumentBody body, int appendLineCount) {
        this.log.info((Object)"ENTER reset()");
        this.dispose();
        this.clear();
        this.set(header, body, appendLineCount);
    }

    public boolean append() {
        return this.append(this.getBodyIterator(), this.getAppendLineCount());
    }

    public boolean appendAll() {
        return this.append(this.getBodyIterator(), Integer.MAX_VALUE);
    }

    public boolean hasNext() {
        return this.getBodyIterator().hasNext();
    }

    public AppendDocumentHeader getHeader() {
        return this.header;
    }

    public AppendDocumentBody getBody() {
        return this.body;
    }

    public int getAppendLineCount() {
        return this.appendLineCount;
    }
}

