/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.swing.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import org.ferris.swing.JAppendScrollPane;
import org.ferris.swing.JAppendTextArea;
import org.ferris.swing.JCaretPositionLabel;
import org.ferris.swing.event.AppendAllEvent;
import org.ferris.swing.event.AppendListener;
import org.ferris.swing.event.AppendNextEvent;
import org.ferris.swing.event.AppendResetEvent;
import org.ferris.swing.text.AppendDocument;
import org.ferris.swing.text.AppendDocumentBody;
import org.ferris.swing.text.AppendDocumentHeader;
import org.ferris.swing.ui.ThrowableDialog;

public class AppendTextFrame
extends JFrame {
    private static final long serialVersionUID = 870972098457072L;
    private static final ResourceBundle rb = ResourceBundle.getBundle(AppendTextFrame.class.getName());
    private Logger log = Logger.getLogger(this.getClass());
    private JAppendScrollPane appendScrollPane = null;
    private JAppendTextArea appendTextArea = null;
    private JPanel contentPanel = null;
    private JPanel statusPanel = null;
    private JButton saveButton = null;
    private JPanel textAreaPanel = null;
    private JCaretPositionLabel caretPositionLabel = null;
    private AppendDocument appendDocument;
    private ExecutorService executorService;
    private MyAppendListener myAppendListener;
    private MyWindowAdapter myWindowAdapter;
    private MySaveAction mySaveAction;

    public AppendTextFrame(AppendDocument doc, String title) {
        this.setAppendDocument(doc);
        this.setTitle(title);
        this.initialize();
    }

    public void reset(AppendDocumentHeader header, AppendDocumentBody body, int appendLineCount) {
        this.log.info((Object)"ENTER reset()");
        this.getAppendTextArea().reset(header, body, appendLineCount);
        this.appendNext();
    }

    public void reset(AppendDocumentHeader header, AppendDocumentBody body) {
        this.log.info((Object)"ENTER reset()");
        this.getAppendTextArea().reset(header, body, this.getAppendDocument().getAppendLineCount());
        this.appendNext();
    }

    private void setAppendDocument(AppendDocument doc) {
        this.appendDocument = doc;
    }

    private AppendDocument getAppendDocument() {
        return this.appendDocument;
    }

    private void initialize() {
        this.setSize(new Dimension(634, 337));
        this.setContentPane(this.getContentPanel());
        this.setDefaultCloseOperation(2);
        this.addWindowListener(this.getMyWindowAdapter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutorService getExecutorService() {
        AppendTextFrame appendTextFrame = this;
        synchronized (appendTextFrame) {
            if (this.executorService == null) {
                this.executorService = Executors.newSingleThreadExecutor();
            }
            this.notifyAll();
            return this.executorService;
        }
    }

    private void appendNext() {
        AppendNextThread t = new AppendNextThread();
        t.setValue();
        this.getExecutorService().execute(t);
    }

    private void appendAll() {
        AppendAllThread t = new AppendAllThread();
        t.setValue();
        this.getExecutorService().execute(t);
    }

    private JAppendScrollPane getAppendScrollPane() {
        if (this.appendScrollPane == null) {
            this.appendScrollPane = new JAppendScrollPane();
            this.appendScrollPane.setViewportView(this.getAppendTextArea());
            this.appendScrollPane.addAppendListener(this.getMyAppendListener());
        }
        return this.appendScrollPane;
    }

    private MyAppendListener getMyAppendListener() {
        if (this.myAppendListener == null) {
            this.myAppendListener = new MyAppendListener();
        }
        return this.myAppendListener;
    }

    private JAppendTextArea getAppendTextArea() {
        if (this.appendTextArea == null) {
            this.appendTextArea = new JAppendTextArea(this.getAppendDocument());
            this.appendTextArea.addAppendListener(this.getMyAppendListener());
            this.appendTextArea.addCaretListener(this.getCaretPositionLabel());
            Font f = new Font("Monospaced", 0, 12);
            this.appendTextArea.setFont(f);
        }
        return this.appendTextArea;
    }

    private JPanel getContentPanel() {
        if (this.contentPanel == null) {
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.gridy = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.gridy = 0;
            this.contentPanel = new JPanel();
            this.contentPanel.setLayout(new GridBagLayout());
            this.contentPanel.add((Component)this.getTextAreaPanel(), gridBagConstraints2);
            this.contentPanel.add((Component)this.getStatusPanel(), gridBagConstraints3);
        }
        return this.contentPanel;
    }

    private JCaretPositionLabel getCaretPositionLabel() {
        if (this.caretPositionLabel == null) {
            this.caretPositionLabel = new JCaretPositionLabel(this.getAppendTextArea().getHeaderLineCount(), this.getAppendTextArea().getBodyLineCount());
            this.caretPositionLabel.setText("^");
        }
        return this.caretPositionLabel;
    }

    private JPanel getStatusPanel() {
        if (this.statusPanel == null) {
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 1;
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.ipadx = 1;
            gridBagConstraints1.ipady = 0;
            gridBagConstraints1.gridwidth = 1;
            gridBagConstraints1.gridheight = 1;
            gridBagConstraints1.insets = new Insets(3, 0, 3, 0);
            gridBagConstraints1.gridy = 0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(0, 2, 0, 0);
            gridBagConstraints.gridy = 0;
            this.statusPanel = new JPanel();
            this.statusPanel.setLayout(new GridBagLayout());
            this.statusPanel.add((Component)this.getCaretPositionLabel(), gridBagConstraints);
            this.statusPanel.add((Component)this.getSaveButton(), gridBagConstraints1);
        }
        return this.statusPanel;
    }

    private JButton getSaveButton() {
        if (this.saveButton == null) {
            this.saveButton = new JButton();
            this.saveButton.setText(rb.getString("save"));
            this.saveButton.addActionListener(this.getMySaveAction());
        }
        return this.saveButton;
    }

    private JPanel getTextAreaPanel() {
        if (this.textAreaPanel == null) {
            this.textAreaPanel = new JPanel();
            this.textAreaPanel.setLayout(new BorderLayout());
            this.textAreaPanel.add((Component)this.getAppendScrollPane(), "Center");
        }
        return this.textAreaPanel;
    }

    private MyWindowAdapter getMyWindowAdapter() {
        if (this.myWindowAdapter == null) {
            this.myWindowAdapter = new MyWindowAdapter();
        }
        return this.myWindowAdapter;
    }

    private MySaveAction getMySaveAction() {
        if (this.mySaveAction == null) {
            this.mySaveAction = new MySaveAction();
        }
        return this.mySaveAction;
    }

    class AppendAllThread
    extends AppendNextThread {
        AppendAllThread() {
        }

        public void run() {
            if (!AppendTextFrame.this.getAppendTextArea().appendedAll()) {
                int proceed = JOptionPane.showConfirmDialog(AppendTextFrame.this, rb.getString("warningMessage"), rb.getString("warningTitle"), 0);
                if (proceed == 0) {
                    try {
                        AppendTextFrame.this.getAppendTextArea().appendAll();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        new ThrowableDialog(e, true).setVisible(true);
                    }
                } else {
                    return;
                }
            }
            try {
                AppendTextFrame.this.getAppendTextArea().setCaretPosition(AppendTextFrame.this.getAppendTextArea().getLineStartOffset(AppendTextFrame.this.getAppendTextArea().getLineCount() - 1));
            }
            catch (Exception e) {
                e.printStackTrace();
                new ThrowableDialog(e, true).setVisible(true);
            }
        }
    }

    class AppendNextThread
    extends Thread {
        AppendNextThread() {
        }

        public void run() {
            try {
                AppendTextFrame.this.getAppendScrollPane().removeAppendListener(AppendTextFrame.this.getMyAppendListener());
                AppendTextFrame.this.getAppendTextArea().append();
                AppendTextFrame.this.getAppendScrollPane().addAppendListener(AppendTextFrame.this.getMyAppendListener());
            }
            catch (Exception e) {
                e.printStackTrace();
                new ThrowableDialog(e, true).setVisible(true);
            }
        }

        public void setValue() {
            AppendTextFrame.this.getAppendScrollPane().getVerticalScrollBar().setValue(AppendTextFrame.this.getAppendScrollPane().getVerticalScrollBar().getValue() - 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MySaveAction
    extends AbstractAction {
        private static final long serialVersionUID = 5056452246511743203L;

        MySaveAction() {
        }

        private Iterator<? extends Object> getHeaderIterator() {
            return AppendTextFrame.this.getAppendDocument().getHeader().getIterator();
        }

        private Iterator<? extends Object> getBodyIterator() {
            return AppendTextFrame.this.getAppendDocument().getBody().getIterator();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser fc = new JFileChooser();
            int returnVal = fc.showSaveDialog(AppendTextFrame.this);
            if (returnVal == 0) {
                File file = fc.getSelectedFile();
                try {
                    FileOutputStream fos = new FileOutputStream(file);
                    PrintWriter writer = new PrintWriter(fos);
                    Iterator<? extends Object> itr = null;
                    boolean headerWritten = false;
                    itr = this.getHeaderIterator();
                    if (itr.hasNext()) {
                        headerWritten = true;
                        do {
                            writer.print(itr.next());
                            if (!itr.hasNext()) continue;
                            writer.println();
                        } while (itr.hasNext());
                    }
                    if ((itr = this.getBodyIterator()).hasNext()) {
                        if (headerWritten) {
                            writer.println();
                        }
                        do {
                            writer.print(itr.next());
                            if (!itr.hasNext()) continue;
                            writer.println();
                        } while (itr.hasNext());
                    }
                    writer.flush();
                    writer.close();
                }
                catch (Throwable t) {
                    new ThrowableDialog(t, false).setVisible(true);
                }
            }
        }
    }

    class MyWindowAdapter
    extends WindowAdapter {
        MyWindowAdapter() {
        }

        public void windowClosed(WindowEvent evnt) {
            AppendTextFrame.this.log.info((Object)"Window closed");
            AppendTextFrame.this.getAppendDocument().dispose();
        }
    }

    class MyAppendListener
    implements AppendListener {
        MyAppendListener() {
        }

        public void append(AppendNextEvent evnt) {
            AppendTextFrame.this.appendNext();
        }

        public void append(AppendAllEvent evnt) {
            AppendTextFrame.this.appendAll();
        }

        public void reset(AppendResetEvent evnt) {
            AppendTextFrame.this.getCaretPositionLabel().setBodyLineCount(AppendTextFrame.this.getAppendTextArea().getBodyLineCount());
            AppendTextFrame.this.getCaretPositionLabel().setHeaderLineCount(AppendTextFrame.this.getAppendTextArea().getHeaderLineCount());
            AppendTextFrame.this.getAppendTextArea().setCaretPosition(0);
        }
    }
}

