/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.swing.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;

public class ThrowableDialog
extends JDialog {
    private static final long serialVersionUID = 8943298052798725980L;
    private static final ResourceBundle rb = ResourceBundle.getBundle(ThrowableDialog.class.getName());

    public ThrowableDialog(Throwable e, boolean exitApplication) {
        this(e, exitApplication, true);
    }

    private ThrowableDialog(Throwable e, final boolean exitApplication, boolean automaticallyMakeVisible) {
        super(new JFrame(), rb.getString("title"), true);
        int i;
        int i2;
        super.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                if (exitApplication) {
                    System.exit(1);
                } else {
                    ThrowableDialog.this.setVisible(false);
                    ThrowableDialog.this.dispose();
                }
            }
        });
        JLabel lblFatal = new JLabel(rb.getString("header"), 0);
        lblFatal.setForeground(Color.red);
        lblFatal.setFont(new Font("Monospaced", 1, 30));
        JTextArea error = new JTextArea();
        error.setFont(new Font("Monospaced", 0, 12));
        error.setEditable(false);
        error.setLineWrap(true);
        error.setWrapStyleWord(true);
        error.setBorder(new EmptyBorder(3, 3, 3, 3));
        StringWriter strWriter = new StringWriter();
        e.printStackTrace(new PrintWriter(strWriter));
        char separator = '\n';
        StringBuffer sp = new StringBuffer();
        String message = rb.getString("message");
        for (i2 = 0; i2 < message.length(); ++i2) {
            sp.append("-");
        }
        sp.append(separator);
        sp.append(message).append(separator);
        for (i2 = 0; i2 < message.length(); ++i2) {
            sp.append("-");
        }
        sp.append(separator);
        sp.append(e.toString()).append(separator);
        sp.append(separator);
        String stackTrace = rb.getString("stackTrace");
        for (i = 0; i < stackTrace.length(); ++i) {
            sp.append("-");
        }
        sp.append(separator);
        sp.append(stackTrace).append(separator);
        for (i = 0; i < stackTrace.length(); ++i) {
            sp.append("-");
        }
        sp.append(separator);
        sp.append(strWriter.toString());
        error.setText(sp.toString());
        error.setCaretPosition(0);
        error.select(0, 0);
        JScrollPane scrollPane = new JScrollPane(error);
        scrollPane.setPreferredSize(new Dimension(550, 250));
        scrollPane.setAutoscrolls(false);
        JPanel pnlButton = new JPanel();
        JButton btnClose = new JButton(rb.getString("close"));
        if (exitApplication) {
            btnClose.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evnt) {
                    System.exit(1);
                }
            });
        } else {
            btnClose.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evnt) {
                    ThrowableDialog.this.setVisible(false);
                    ThrowableDialog.this.dispose();
                }
            });
        }
        pnlButton.add(btnClose);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)lblFatal, "North");
        panel.add((Component)scrollPane, "Center");
        panel.add((Component)pnlButton, "South");
        super.getContentPane().add(panel);
        super.pack();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        super.setLocation((int)((d.getWidth() - (double)super.getWidth()) / 2.0), (int)((d.getHeight() - (double)super.getHeight()) / 2.0));
        if (automaticallyMakeVisible) {
            super.setVisible(true);
        }
    }
}

