/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.journal.gui.view.panel;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.ferris.journal.gui.i18n.i18n;
import org.ferris.journal.gui.view.textfield.KEmailTextField;
import org.ferris.journal.gui.view.textfield.KPasswordField;

public class KCredentialsPanel
extends JPanel {
    private static final long serialVersionUID = 129070928409872L;
    private JLabel emailLabel = null;
    private JLabel passwordLabel = null;
    private KEmailTextField emailText = null;
    private KPasswordField passwordText = null;
    private Preferences prefs = null;

    public KCredentialsPanel() {
        this.initialize();
    }

    private void initialize() {
        this.prefs = Preferences.userNodeForPackage(this.getClass());
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    KCredentialsPanel.this.prefs.put("email", KCredentialsPanel.this.getEmailText().getText());
                    KCredentialsPanel.this.prefs.flush();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints3.gridx = 1;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints2.gridx = 1;
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.anchor = 13;
        gridBagConstraints1.insets = new Insets(8, 5, 8, 5);
        gridBagConstraints1.fill = 0;
        gridBagConstraints1.gridy = 1;
        this.passwordLabel = new JLabel();
        this.passwordLabel.setText(i18n.getString("label.password", new Object[0]));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(8, 5, 8, 5);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridy = 0;
        this.emailLabel = new JLabel();
        this.emailLabel.setText(i18n.getString("label.username", new Object[0]));
        this.setSize(300, 67);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.emailLabel, gridBagConstraints);
        this.add((Component)this.passwordLabel, gridBagConstraints1);
        this.add((Component)this.getEmailText(), gridBagConstraints2);
        this.add((Component)this.getPasswordText(), gridBagConstraints3);
    }

    private KEmailTextField getEmailText() {
        if (this.emailText == null) {
            this.emailText = new KEmailTextField();
            this.emailText.setText(this.prefs.get("email", ""));
        }
        return this.emailText;
    }

    private KPasswordField getPasswordText() {
        if (this.passwordText == null) {
            this.passwordText = new KPasswordField();
        }
        return this.passwordText;
    }

    public void focusOnPassword() {
        this.getPasswordText().grabFocus();
    }

    public void validate(List<String> explainations) {
        this.getEmailText().validate(explainations);
        this.getPasswordText().validate(explainations);
    }

    public String getUsername() {
        return this.getEmailText().getText();
    }

    public char[] getPassword() {
        return this.getPasswordText().getPassword();
    }
}

