/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.util.search;

import java.util.Arrays;
import org.ferris.util.search.BinarySearchResults;

public class BinarySearchTools {
    private double[] array;

    public BinarySearchTools(double[] array) {
        this.array = array;
    }

    public BinarySearchResults search(double min, double max) {
        BinarySearchResults sa = new BinarySearchResults();
        int smin = Arrays.binarySearch(this.array, min);
        int smax = Arrays.binarySearch(this.array, max);
        if (smin >= 0 && smax >= 0) {
            sa.index = smin;
            sa.length = smax - sa.index + 1;
        } else if (smin >= 0 && smax < 0) {
            smax = this.toIndex(smax);
            sa.index = smin;
            sa.length = smax - sa.index;
        } else if (smin < 0 && smax >= 0) {
            smin = this.toIndex(smin);
            sa.index = smin;
            sa.length = ++smax - sa.index;
        } else if (smin < 0 && smax < 0) {
            smin = this.toIndex(smin);
            smax = this.toIndex(smax);
            sa.index = smin;
            sa.length = smax - sa.index;
        } else {
            throw new RuntimeException("smin = " + smin + ", smax = " + smax + ", is not understood.");
        }
        return sa;
    }

    public int getIndex(double d) {
        return this.toIndex(Arrays.binarySearch(this.array, d));
    }

    private int toIndex(int i) {
        return i >= 0 ? i : Math.abs(i + 1);
    }

    public int length() {
        return this.array.length;
    }
}

