/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.util.sequence;

import org.apache.commons.lang.StringUtils;
import org.ferris.util.sequence.Sequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceLeftPaddingDecorator
implements Sequence<String> {
    private Sequence<? extends Object> sequence;
    private String padding;
    private int paddedLength;

    public String toString() {
        StringBuilder sp = new StringBuilder();
        sp.append("[SequenceLeftPaddingDecorator");
        sp.append(" padding=\"").append(this.getPadding()).append("\"");
        sp.append(" length=").append(this.getPaddedLength());
        sp.append("]");
        return sp.toString();
    }

    private void setSequence(Sequence<? extends Object> sequence) {
        if (sequence == null) {
            throw new IllegalArgumentException("Method " + this.getClass() + ".setSequence() says," + " the sequence parameter is null.");
        }
        this.sequence = sequence;
    }

    private void setPadding(String padding) {
        if (padding == null) {
            throw new IllegalArgumentException("Method " + this.getClass() + ".setPadding() says," + " the padding parameter is null.");
        }
        this.padding = padding;
    }

    private int getPaddingLength() {
        return this.getPadding().length();
    }

    private void setPaddedLength(int paddedLength) {
        if (paddedLength == 0) {
            throw new IllegalArgumentException("Method " + this.getClass() + ".setPaddedLength() says," + " the paddedLength parameter == 0.");
        }
        if (paddedLength < 0) {
            throw new IllegalArgumentException("Method " + this.getClass() + ".setPaddedLength() says," + " the paddedLength parameter, \"" + paddedLength + "\"," + " is less than 0.");
        }
        if (paddedLength == this.getPaddingLength()) {
            throw new IllegalArgumentException("Method " + this.getClass() + ".setPaddedLength() says," + " the paddedLength parameter, \"" + paddedLength + "\"," + " is the same length as the " + " padding string, \"" + this.getPadding() + "\", \"" + this.getPaddingLength() + "\"");
        }
        if (paddedLength < this.getPaddingLength()) {
            throw new IllegalArgumentException("Method " + this.getClass() + ".setPaddedLength() says," + " the paddedLength parameter, \"" + paddedLength + "\"," + " is smaller than the " + " padding string, \"" + this.getPadding() + "\", \"" + this.getPaddingLength() + "\"");
        }
        this.paddedLength = paddedLength;
    }

    protected int getPaddedLength() {
        return this.paddedLength;
    }

    protected String getPadding() {
        return this.padding;
    }

    protected Sequence<? extends Object> getSequence() {
        return this.sequence;
    }

    public SequenceLeftPaddingDecorator(Sequence<? extends Object> sequence, String padding, int paddedLength) {
        this.setSequence(sequence);
        this.setPadding(padding);
        this.setPaddedLength(paddedLength);
    }

    @Override
    public String getNext() {
        return StringUtils.leftPad((String)String.valueOf(this.getSequence().getNext()), (int)this.getPaddedLength(), (String)this.getPadding());
    }

    @Override
    public boolean hasNext() {
        return this.getSequence().hasNext();
    }
}

