/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.util.split;

import java.math.BigDecimal;
import java.util.Enumeration;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringSplitter
implements Enumeration<String> {
    private String splitMe;
    private String regex;
    private int limit;
    private int index;
    private String[] elements;
    private boolean autoTrim;

    private String nextNullElement() {
        String element = null;
        if (this.hasMoreElements()) {
            element = this.elements[this.index];
            ++this.index;
            if (this.getAutoTrim()) {
                element = element.trim();
            }
        }
        return element;
    }

    private void setSplitMe(String s) {
        this.splitMe = s;
    }

    private void setRegEx(String s) {
        this.regex = s;
    }

    private void setLimit(int i) {
        this.limit = i;
    }

    private void setElements() {
        this.elements = this.getSplitMe().split(this.getRegEx(), this.getLimit());
        this.index = 0;
    }

    public StringSplitter(String splitMe, String regex) {
        if (splitMe == null) {
            throw new IllegalArgumentException("The argument \"splitMe\" is null");
        }
        if (regex == null) {
            throw new IllegalArgumentException("The argument \"regex\" is null");
        }
        if (regex.length() == 0) {
            throw new IllegalArgumentException("The argument \"regex\" is an empty string");
        }
        this.setSplitMe(splitMe);
        this.setRegEx(regex);
        this.setLimit(Integer.MAX_VALUE);
        this.setAutoTrim(false);
        this.setElements();
    }

    @Override
    public boolean hasMoreElements() {
        return this.index < this.elements.length;
    }

    @Override
    public String nextElement() {
        String element = this.nextNullElement();
        if (element == null) {
            throw new NoSuchElementException("There are no more elements");
        }
        return element;
    }

    public int countElements() {
        return this.elements.length - this.index;
    }

    public BigDecimal nextBigDecimal() {
        String element = this.nextNullElement();
        try {
            return new BigDecimal(element);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("The element \"" + element + "\" is not numeric");
        }
    }

    public int getLimit() {
        return this.limit;
    }

    public String getRegEx() {
        return this.regex;
    }

    public String getSplitMe() {
        return this.splitMe;
    }

    public void setAutoTrim(boolean b) {
        this.autoTrim = b;
    }

    public boolean getAutoTrim() {
        return this.autoTrim;
    }
}

