/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.crypto;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.ferris.crypto.KeyMaterialLocator;
import org.ferris.crypto.KeyMaterialLocatorByDefault;

public class Blowfish {
    private Cipher cipher;
    private SecretKeySpec skeySpec;

    public Blowfish(KeyMaterialLocator locator) {
        try {
            this.skeySpec = new SecretKeySpec(locator.locate(), "Blowfish");
            this.cipher = Cipher.getInstance("Blowfish");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (NoSuchPaddingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (Throwable t) {
            throw new RuntimeException(t.getMessage(), t);
        }
    }

    public Blowfish() {
        this(new KeyMaterialLocatorByDefault("Blowfish"));
    }

    public byte[] encrypt(String clearText) {
        if (clearText == null) {
            throw new IllegalArgumentException("Method " + this.getClass() + ".encrypt() says," + " parameter clearText is null.");
        }
        try {
            this.cipher.init(1, this.skeySpec);
            return this.cipher.doFinal(clearText.getBytes());
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (IllegalBlockSizeException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (BadPaddingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (Throwable t) {
            throw new RuntimeException(t.getMessage(), t);
        }
    }

    public String decrypt(byte[] encryptedBytes) {
        if (encryptedBytes == null || encryptedBytes.length == 0) {
            throw new IllegalArgumentException("Method " + this.getClass() + ".decrypt() says," + " parameter cipherBytes is null.");
        }
        try {
            this.cipher.init(2, this.skeySpec);
            return new String(this.cipher.doFinal(encryptedBytes));
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (IllegalBlockSizeException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (BadPaddingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (Throwable t) {
            throw new RuntimeException(t.getMessage(), t);
        }
    }
}

