/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.crypto;

import java.io.File;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.apache.log4j.Logger;
import org.ferris.crypto.KeyMaterial;
import org.ferris.crypto.KeyMaterialLocator;

public class KeyMaterialLocatorByDefault
implements KeyMaterialLocator {
    private static Logger log = Logger.getLogger(KeyMaterialLocatorByDefault.class);
    private KeyMaterial encoded;
    private String algorithm;

    private void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    private KeyMaterial getKeyMaterialEncoded() {
        if (this.encoded == null) {
            log.debug((Object)"new KeyMaterial()");
            this.encoded = new KeyMaterial();
        }
        return this.encoded;
    }

    private byte[] locateInClasspath() {
        log.info((Object)"ENTER: locateInClasspath()");
        String file = "/" + this.getKeyMaterialFilename();
        InputStream is = this.getClass().getResourceAsStream(file);
        if (is == null) {
            log.info((Object)("Not found in classpath: " + file));
            return null;
        }
        log.info((Object)("Found in classpath: " + file));
        return this.getKeyMaterialEncoded().xmlDecode(is);
    }

    private byte[] locateInFileSystem() {
        log.info((Object)"ENTER: locateInFileSystem()");
        byte[] bytes = null;
        File keyMaterialFile = this.getKeyMaterialFile();
        if (keyMaterialFile.exists()) {
            log.info((Object)("File exists and ready for decode: " + keyMaterialFile));
            bytes = this.getKeyMaterialEncoded().xmlDecode(keyMaterialFile);
        }
        if (bytes == null) {
            KeyGenerator kgen;
            log.info((Object)"Don't have encoded bytes yet");
            log.debug((Object)"KeyGenerator.getInstance()");
            try {
                kgen = KeyGenerator.getInstance(this.getAlgorithm());
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            log.debug((Object)"generateKey()");
            SecretKey skey = kgen.generateKey();
            log.info((Object)("Save encoded bytes to " + keyMaterialFile));
            this.getKeyMaterialEncoded().xmlEncode(skey.getEncoded(), keyMaterialFile);
            log.info((Object)("Retrieved encoded bytes from newly created " + keyMaterialFile));
            bytes = this.getKeyMaterialEncoded().xmlDecode(keyMaterialFile);
        }
        if (bytes == null) {
            log.info((Object)"Still don't have encoded bytes yet! Throw exception");
            throw new RuntimeException("Unable to decode or store a key material.");
        }
        return bytes;
    }

    public KeyMaterialLocatorByDefault(String algorithm) {
        this.setAlgorithm(algorithm);
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    protected File getFerrisDir() {
        log.info((Object)"ENTER: getFerrisDir()");
        log.debug((Object)"init ferrisDirPath");
        String ferrisDirPath = System.getProperty("java.io.tmpdir") + "/.ferris";
        log.debug((Object)"new File()");
        File ferrisDir = new File(ferrisDirPath);
        if (!ferrisDir.exists()) {
            log.info((Object)("Does not exist: " + ferrisDir));
            for (int i = 0; !ferrisDir.mkdirs() && i < 1000; ++i) {
                log.info((Object)("Attempt[" + i + "] to create: " + ferrisDir));
            }
            if (!ferrisDir.exists()) {
                throw new RuntimeException("Unable to create directory: \"" + ferrisDir + "\"");
            }
        }
        return ferrisDir;
    }

    protected File getKeyMaterialFile() {
        log.info((Object)"ENTER: getKeyMaterialFile()");
        log.debug((Object)"new File()");
        File file = new File(this.getFerrisDir(), this.getKeyMaterialFilename());
        return file;
    }

    protected String getKeyMaterialFilename() {
        return "ferris-" + this.getAlgorithm() + ".xml";
    }

    public byte[] locate() {
        log.info((Object)"ENTER: locate()");
        byte[] bytes = null;
        bytes = this.locateInClasspath();
        if (bytes != null) {
            log.info((Object)"Found encoded bytes in classpath!");
            return bytes;
        }
        bytes = this.locateInFileSystem();
        if (bytes != null) {
            log.info((Object)"Found encoded bytes in file system!");
            return bytes;
        }
        throw new RuntimeException("Key material encoded bytes not found anywhere.");
    }
}

