/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.crypto.applet;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import javax.swing.ButtonGroup;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.ferris.crypto.Blowfish;
import org.ferris.crypto.DES;
import org.ferris.crypto.applet.KeyMaterialLocatorAbstract;
import org.ferris.crypto.applet.KeyMaterialLocatorForBlowfish;
import org.ferris.crypto.applet.KeyMaterialLocatorForDES;

public class Applet
extends JApplet
implements ActionListener {
    private Logger log = Logger.getLogger(this.getClass());
    private static final long serialVersionUID = 2378423767489L;
    private JPanel jContentPane = null;
    private JPanel contentPanel = null;
    private JLabel inputLabel = null;
    private JTextField inputText = null;
    private JLabel algorithmLabel = null;
    private JRadioButton desRadioButton = null;
    private JRadioButton blowfishRadioButton = null;
    private JLabel operationLabel = null;
    private JPanel buttonPanel = null;
    private JButton encryptButton = null;
    private JButton decryptButton = null;
    private JLabel resultsLabel = null;
    private JTextField resultsText = null;
    private ButtonGroup radioButtonGroup;
    private JLabel tempKeyMaterial = null;
    private JTextField tempKeyMaterialText = null;
    private KeyMaterialLocatorAbstract keyMaterialLocatorForBlowfish;
    private KeyMaterialLocatorAbstract keyMaterialLocatorForDES;
    private JTextPane tempKeyMaterialDescriptionTextPane = null;
    private JLabel enterKeyMaterialLabel = null;
    private JTextField enterKeyMaterialText = null;

    private ButtonGroup getRadioButtonGroup() {
        if (this.radioButtonGroup == null) {
            this.radioButtonGroup = new ButtonGroup();
        }
        return this.radioButtonGroup;
    }

    public void init() {
        this.setContentPane(this.getJContentPane());
        this.setSize(525, 375);
        this.setPreferredSize(new Dimension(525, 375));
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.setPreferredSize(new Dimension(400, 164));
            this.jContentPane.add((Component)this.getContentPanel(), "North");
        }
        return this.jContentPane;
    }

    private JPanel getContentPanel() {
        if (this.contentPanel == null) {
            GridBagConstraints gridBagConstraints22 = new GridBagConstraints();
            gridBagConstraints22.fill = 2;
            gridBagConstraints22.gridy = 3;
            gridBagConstraints22.weightx = 1.0;
            gridBagConstraints22.anchor = 15;
            gridBagConstraints22.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints22.gridx = 1;
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.gridx = 0;
            gridBagConstraints12.insets = new Insets(22, 5, 0, 5);
            gridBagConstraints12.gridy = 3;
            this.enterKeyMaterialLabel = new JLabel();
            this.enterKeyMaterialLabel.setText("<html>Step #3 (optional)<br>Enter your Key Material byte[] :</html>");
            GridBagConstraints gridBagConstraints31 = new GridBagConstraints();
            gridBagConstraints31.fill = 1;
            gridBagConstraints31.gridy = 7;
            gridBagConstraints31.weightx = 0.0;
            gridBagConstraints31.weighty = 0.0;
            gridBagConstraints31.insets = new Insets(5, 5, 0, 5);
            gridBagConstraints31.gridwidth = 0;
            gridBagConstraints31.gridheight = 0;
            gridBagConstraints31.anchor = 10;
            gridBagConstraints31.gridx = 1;
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints21.fill = 2;
            gridBagConstraints21.gridy = 6;
            gridBagConstraints21.weightx = 1.0;
            gridBagConstraints21.insets = new Insets(5, 5, 0, 5);
            gridBagConstraints21.anchor = 15;
            gridBagConstraints21.gridx = 1;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.insets = new Insets(5, 5, 0, 5);
            gridBagConstraints11.anchor = 17;
            gridBagConstraints11.gridy = 6;
            this.tempKeyMaterial = new JLabel();
            this.tempKeyMaterial.setText("Temp Key Material:");
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.fill = 2;
            gridBagConstraints8.gridy = 5;
            gridBagConstraints8.weightx = 1.0;
            gridBagConstraints8.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints8.anchor = 15;
            gridBagConstraints8.gridx = 1;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.anchor = 17;
            gridBagConstraints7.insets = new Insets(25, 5, 0, 5);
            gridBagConstraints7.gridy = 5;
            this.resultsLabel = new JLabel();
            this.resultsLabel.setText("Results :");
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 1;
            gridBagConstraints6.fill = 2;
            gridBagConstraints6.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints6.anchor = 15;
            gridBagConstraints6.gridy = 4;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.anchor = 17;
            gridBagConstraints5.insets = new Insets(22, 5, 0, 5);
            gridBagConstraints5.gridy = 4;
            this.operationLabel = new JLabel();
            this.operationLabel.setText("<html>Step #4<br>Choose Operation :</html>");
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 1;
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.gridy = 1;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 1;
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.insets = new Insets(10, 0, 0, 0);
            gridBagConstraints3.gridy = 0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.insets = new Insets(10, 5, 0, 5);
            gridBagConstraints2.gridy = 0;
            this.algorithmLabel = new JLabel();
            this.algorithmLabel.setText("<html>Step #1<br>Select Algorithm :</html>");
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.gridy = 2;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints1.anchor = 15;
            gridBagConstraints1.gridx = 1;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.fill = 1;
            this.inputLabel = new JLabel();
            this.inputLabel.setText("<html>Step #2<br>Enter clear-text or<br>Base64 encoded string :</html>");
            this.contentPanel = new JPanel();
            this.contentPanel.setLayout(new GridBagLayout());
            this.contentPanel.add((Component)this.inputLabel, gridBagConstraints);
            this.contentPanel.add((Component)this.getInputText(), gridBagConstraints1);
            this.contentPanel.add((Component)this.algorithmLabel, gridBagConstraints2);
            this.contentPanel.add((Component)this.getDesRadioButton(), gridBagConstraints3);
            this.contentPanel.add((Component)this.getBlowfishRadioButton(), gridBagConstraints4);
            this.contentPanel.add((Component)this.operationLabel, gridBagConstraints5);
            this.contentPanel.add((Component)this.getButtonPanel(), gridBagConstraints6);
            this.contentPanel.add((Component)this.resultsLabel, gridBagConstraints7);
            this.contentPanel.add((Component)this.getResultsText(), gridBagConstraints8);
            this.contentPanel.add((Component)this.tempKeyMaterial, gridBagConstraints11);
            this.contentPanel.add((Component)this.getTempKeyMaterialText(), gridBagConstraints21);
            this.contentPanel.add((Component)this.getTempKeyMaterialDescriptionTextPane(), gridBagConstraints31);
            this.contentPanel.add((Component)this.enterKeyMaterialLabel, gridBagConstraints12);
            this.contentPanel.add((Component)this.getEnterKeyMaterialText(), gridBagConstraints22);
        }
        return this.contentPanel;
    }

    private JTextField getInputText() {
        if (this.inputText == null) {
            this.inputText = new JTextField();
        }
        return this.inputText;
    }

    private JRadioButton getDesRadioButton() {
        if (this.desRadioButton == null) {
            this.desRadioButton = new JRadioButton();
            this.desRadioButton.setText("DES and Base64");
            this.getRadioButtonGroup().add(this.desRadioButton);
        }
        return this.desRadioButton;
    }

    private JRadioButton getBlowfishRadioButton() {
        if (this.blowfishRadioButton == null) {
            this.blowfishRadioButton = new JRadioButton();
            this.blowfishRadioButton.setText("Blowfish and Base64");
            this.getRadioButtonGroup().add(this.blowfishRadioButton);
        }
        return this.blowfishRadioButton;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(0);
            flowLayout.setVgap(0);
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(flowLayout);
            this.buttonPanel.add((Component)this.getEncryptButton(), null);
            this.buttonPanel.add((Component)this.getDecryptButton(), null);
        }
        return this.buttonPanel;
    }

    private JButton getEncryptButton() {
        if (this.encryptButton == null) {
            this.encryptButton = new JButton();
            this.encryptButton.setText("Encrypt");
            this.encryptButton.setActionCommand("encrypt");
            this.encryptButton.addActionListener(this);
        }
        return this.encryptButton;
    }

    private JButton getDecryptButton() {
        if (this.decryptButton == null) {
            this.decryptButton = new JButton();
            this.decryptButton.setText("Decrypt");
            this.decryptButton.setActionCommand("decrypt");
            this.decryptButton.addActionListener(this);
        }
        return this.decryptButton;
    }

    private JTextField getResultsText() {
        if (this.resultsText == null) {
            this.resultsText = new JTextField();
        }
        return this.resultsText;
    }

    public void actionPerformed(ActionEvent e) {
        String input = this.getInputText().getText();
        this.getResultsText().setText("");
        try {
            String keyMaterialByteArray = this.getEnterKeyMaterialText().getText().trim();
            if (keyMaterialByteArray.length() == 0) {
                keyMaterialByteArray = null;
            }
            this.log.info((Object)("User Key Material: " + keyMaterialByteArray));
            if ("encrypt".equals(e.getActionCommand())) {
                this.log.info((Object)"encrypt");
                if (this.getDesRadioButton().isSelected()) {
                    this.getKeyMaterialLocatorForDES().setEncoded(keyMaterialByteArray);
                    DES des = new DES(this.getKeyMaterialLocatorForDES());
                    byte[] bytes = des.encrypt(input);
                    String b64 = new String(new Base64().encode(bytes));
                    this.getResultsText().setText(b64);
                    this.getTempKeyMaterialText().setText(Arrays.toString(this.getKeyMaterialLocatorForDES().locate()));
                } else if (this.getBlowfishRadioButton().isSelected()) {
                    this.getKeyMaterialLocatorForBlowfish().setEncoded(keyMaterialByteArray);
                    Blowfish blowfish = new Blowfish(this.getKeyMaterialLocatorForBlowfish());
                    byte[] bytes = blowfish.encrypt(input);
                    String b64 = new String(new Base64().encode(bytes));
                    this.getResultsText().setText(b64);
                    this.getTempKeyMaterialText().setText(Arrays.toString(this.getKeyMaterialLocatorForBlowfish().locate()).toString());
                } else {
                    JOptionPane.showMessageDialog(this, "Select an algorithm");
                }
            } else if ("decrypt".equals(e.getActionCommand())) {
                this.log.info((Object)"decrypt");
                if (this.getDesRadioButton().isSelected()) {
                    this.getKeyMaterialLocatorForDES().setEncoded(keyMaterialByteArray);
                    byte[] bytes = new Base64().decode(input.getBytes());
                    DES des = new DES(this.getKeyMaterialLocatorForDES());
                    String results = des.decrypt(bytes);
                    this.getResultsText().setText(results);
                    this.getTempKeyMaterialText().setText(Arrays.toString(this.getKeyMaterialLocatorForDES().locate()));
                } else if (this.getBlowfishRadioButton().isSelected()) {
                    this.getKeyMaterialLocatorForBlowfish().setEncoded(keyMaterialByteArray);
                    byte[] bytes = new Base64().decode(input.getBytes());
                    Blowfish blowfish = new Blowfish(this.getKeyMaterialLocatorForBlowfish());
                    String results = blowfish.decrypt(bytes);
                    this.getResultsText().setText(results);
                    this.getTempKeyMaterialText().setText(Arrays.toString(this.getKeyMaterialLocatorForBlowfish().locate()));
                } else {
                    JOptionPane.showMessageDialog(this, "Select an algorithm");
                }
            }
        }
        catch (Throwable t) {
            StringWriter writer = new StringWriter();
            PrintWriter pw = new PrintWriter(writer);
            t.printStackTrace(pw);
            pw.flush();
            JOptionPane.showMessageDialog(this, writer.toString(), "Opps", 0);
        }
    }

    private JTextField getTempKeyMaterialText() {
        if (this.tempKeyMaterialText == null) {
            this.tempKeyMaterialText = new JTextField();
            this.tempKeyMaterialText.setEditable(false);
        }
        return this.tempKeyMaterialText;
    }

    private KeyMaterialLocatorAbstract getKeyMaterialLocatorForBlowfish() {
        if (this.keyMaterialLocatorForBlowfish == null) {
            this.keyMaterialLocatorForBlowfish = new KeyMaterialLocatorForBlowfish();
        }
        return this.keyMaterialLocatorForBlowfish;
    }

    private KeyMaterialLocatorAbstract getKeyMaterialLocatorForDES() {
        if (this.keyMaterialLocatorForDES == null) {
            this.keyMaterialLocatorForDES = new KeyMaterialLocatorForDES();
        }
        return this.keyMaterialLocatorForDES;
    }

    private JTextPane getTempKeyMaterialDescriptionTextPane() {
        if (this.tempKeyMaterialDescriptionTextPane == null) {
            this.tempKeyMaterialDescriptionTextPane = new JTextPane();
            this.tempKeyMaterialDescriptionTextPane.setText(this.getTempKeyMaterialDescription());
            this.tempKeyMaterialDescriptionTextPane.setEnabled(true);
            this.tempKeyMaterialDescriptionTextPane.setFont(new Font("Arial", 0, 10));
            this.tempKeyMaterialDescriptionTextPane.setPreferredSize(new Dimension(50, 80));
            this.tempKeyMaterialDescriptionTextPane.setEditable(false);
        }
        return this.tempKeyMaterialDescriptionTextPane;
    }

    private String getTempKeyMaterialDescription() {
        StringBuilder sp = new StringBuilder();
        sp.append("The Temp Key Material is a secret byte[] which").append(" you should keep safe. It is used by the algorithm").append(" to perform the encryption and decryption.  The same").append(" Temp Key Material byte[] used for encryption MUST").append(" also be used for decryption. If you try to decrypt").append(" with a different key, the decryption will fail.").append("You should save this Temp Key Material value and").append(" implement a org.ferrs.crypto.KeyMaterialLocator ").append(" to return it.");
        return sp.toString();
    }

    private JTextField getEnterKeyMaterialText() {
        if (this.enterKeyMaterialText == null) {
            this.enterKeyMaterialText = new JTextField();
        }
        return this.enterKeyMaterialText;
    }
}

