/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.crypto.applet;

import java.security.NoSuchAlgorithmException;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.apache.log4j.Logger;
import org.ferris.crypto.KeyMaterialLocator;

public abstract class KeyMaterialLocatorAbstract
implements KeyMaterialLocator {
    private Logger log = Logger.getLogger(this.getClass());
    private byte[] userEncoded = null;
    private byte[] generatedEncoded = null;

    public void setEncoded(String array) {
        if (array == null) {
            this.userEncoded = null;
        } else {
            String[] tokens;
            if ((array = array.trim()).startsWith("[")) {
                array = array.substring(1).trim();
            }
            if (array.endsWith("]")) {
                array = array.substring(0, array.indexOf(93)).trim();
            }
            if ((tokens = array.split(",")) != null && tokens.length > 0) {
                this.userEncoded = new byte[tokens.length];
                for (int i = 0; i < tokens.length; ++i) {
                    this.userEncoded[i] = Byte.valueOf(tokens[i].trim());
                }
            }
        }
    }

    public byte[] locate() {
        if (this.userEncoded != null) {
            return this.userEncoded;
        }
        if (this.generatedEncoded == null) {
            KeyGenerator kgen;
            this.log.info((Object)"KeyGenerator.getInstance()");
            try {
                kgen = KeyGenerator.getInstance(this.getAlgorithm());
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            this.log.info((Object)"generateKey()");
            SecretKey skey = kgen.generateKey();
            this.log.info((Object)"getEncoded()");
            this.generatedEncoded = skey.getEncoded();
            this.log.info((Object)"cleanup");
            kgen = null;
            Object var2_3 = null;
        }
        return this.generatedEncoded;
    }

    public abstract String getAlgorithm();
}

