package org.ferris.journal.gui.controller;

import static org.ferris.journal.gui.i18n.i18n.getString;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.codec.binary.Base64;
import org.ferris.awt.ContainerTools;
import org.ferris.crypto.Blowfish;
import org.ferris.journal.gui.crypto.KeyMaterialLocatorForBlowfish;
import org.ferris.journal.gui.data.AccountData;
import org.ferris.journal.gui.model.Model;
import org.ferris.journal.gui.view.dialog.KErrorDialog;
import org.ferris.journal.gui.view.frame.KLoginFrame;
import org.ferris.journal.jws.account.Account;
import org.ferris.swing.JComponentTools;

public class LoginController 
{	
	private Model model;
	private LoginController setModel(Model model) {
		this.model = model; return this;
	}
	private Model getModel() {
		return this.model;
	}
	
	
	private KLoginFrame view;
	private LoginController setView() {
		this.view = new KLoginFrame(this, getModel());
		return this;
	}
	private KLoginFrame getView() {
		return this.view;
	}
	
	
	public LoginController(Model model) { 
		setModel(model)
			.setView()
			.getView().setVisible(true);		
	}
	
	
	public void exit() {
		getModel().release();
	}
	
	public void disposeView() {
		if (getView() != null && getView().isVisible()) {
			getView().setVisible(false);
			getView().dispose();
		}
	}
	
	public void login(final String username, final char [] unencryptedPassword)
	{
		new Thread() {
			public void run() 
			{	
				try {
					ContainerTools.setEnabled(
						  view.getJContentPane()
						, false
					);
					JComponentTools.setWaitCursor(
						view.getJContentPane()
					);
					
					model.performingOperation(getString("op.newAccount"));		
					Account a = new Account();
					
					model.performingOperation(getString("op.setUsername"));
					a.setUsername(username);
					
					model.performingOperation(getString("op.setPassword"));
					a.setPassword(		
						new String(
							Base64.encodeBase64(
								new Blowfish(
									new KeyMaterialLocatorForBlowfish()
								).encrypt(new String(unencryptedPassword))
							)
						)
					);

					model.performingOperation(getString("op.login"));
					a = AccountData.getInstance().login(a);
					
					if (a == null) {
						model.performingOperation(getString("op.loginFailed"));
						List<String>
							errors = new ArrayList<String>();
						errors.add(getString("loginFailed"));
						new KErrorDialog(view, errors);
					} else {
						model.setAccount(a);
						view.setVisible(false);
						view.dispose();
						new EntryController(getModel());
					}
				}
				finally {
					ContainerTools.setEnabled(
						  view.getJContentPane()
						, true
					);
					JComponentTools.setDefaultCursor(
						view.getJContentPane()
					);
				}					
			}
		}.start();
		
	}
	
	public void register(final String username, final char [] unencryptedPassword) 
	{
		new Thread() {
			public void run() {
				try {
					ContainerTools.setEnabled(
						  view.getJContentPane()
						, false
					);
					JComponentTools.setWaitCursor(
						view.getJContentPane()
					);
					
					model.performingOperation(getString("op.newAccount"));		
					Account a = new Account();
					
					model.performingOperation(getString("op.setUsername"));
					a.setUsername(username);
					
					model.performingOperation(getString("op.setPassword"));
					a.setPassword(		
						new String(
							Base64.encodeBase64(
								new Blowfish(
									new KeyMaterialLocatorForBlowfish()
								).encrypt(new String(unencryptedPassword))
							)
						)
					);
					
					model.performingOperation(getString("op.register"));
					a = AccountData.getInstance().register(a);				
					
					if (a == null) {
						model.performingOperation(getString("op.registerFailed"));
						List<String>
							errors = new ArrayList<String>();
						errors.add(getString("registerFailed"));
						new KErrorDialog(view, errors);
					} else {
						model.setAccount(a);
						view.setVisible(false);
						view.dispose();
						new EntryController(getModel());
					}
				}
				finally {
					ContainerTools.setEnabled(
						  view.getJContentPane()
						, true
					);
					JComponentTools.setDefaultCursor(
						view.getJContentPane()
					);
				}
			}
		}.start();
	}
}
