package org.ferris.journal.gui.controller;

import static org.ferris.journal.gui.i18n.i18n.getString;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;

import org.ferris.journal.gui.data.JournalEntryData;
import org.ferris.journal.gui.model.Model;
import org.ferris.journal.gui.view.frame.KSearchFrame;
import org.ferris.journal.jws.journalentry.JournalEntry;
import org.ferris.awt.ContainerTools;
import org.ferris.swing.JComponentTools;
import org.ferris.swing.ui.ThrowableDialog;

public class SearchController 
{
	private Model model;
	private SearchController setModel(Model model) {
		this.model = model; return this;
	}
	private Model getModel() {
		return this.model;
	}
	
	
	private KSearchFrame view;
	private SearchController setView() {
		this.view = new KSearchFrame(this, getModel());
		return this;
	}
	private KSearchFrame getView() {
		return this.view;
	}
	
	private SearchController setData()
	{		
		return this;
	}
	
	public SearchController(Model model) { 
		setModel(model)
			.setData()
			.setView()
			.getView().setVisible(true);
	}
	
	
	public void exit() {
		getModel().release();
	}
	
	
	public void close() {
		getView().setVisible(false);
		getView().dispose();
	}
	
	public void edit(JournalEntry entry)
	{
		model.editJournalEntry(entry);
	}
	
	public void search(		
		  final String keyword
		, final long [] journalIds
		, final Calendar minInclusive
		, final Calendar maxInclusive
	) 
	{
		new Thread() {
			public void run() 
			{	
				ContainerTools.setEnabled(
					  view.getJContentPane()
					, false
				);
				JComponentTools.setWaitCursor(
					view.getJContentPane()
				);
				
				model.performingOperation(getString("op.search.searching"));
				
				List<JournalEntry> searchResults 
					= JournalEntryData.getInstance().search(
						  model.getAccount().getId()
						, keyword
						, journalIds
						, minInclusive
						, maxInclusive
					);
				
				model.performingOperation(getString("op.search.found", searchResults.size()));

				ContainerTools.setEnabled(
					  view.getJContentPane()
					, true
				);
				JComponentTools.setDefaultCursor(
					view.getJContentPane()
				);
				
				model.setJournalEntrySearchResults(searchResults);
			}
		}.start();
	}

	public void export(final File selectedFile, final List<JournalEntry> entries)
	{
		new Thread() {
			public void run() 
			{	
				ContainerTools.setEnabled(
					  view.getJContentPane()
					, false
				);
				JComponentTools.setWaitCursor(
					view.getJContentPane()
				);
				{
					OutputStream os = null;
					PrintWriter writer = null;
					SimpleDateFormat sdf = new SimpleDateFormat("E, MM/dd/yyyy");
										
					try {
						model.performingOperation(getString("op.export.os",selectedFile.getName()));
						os = new FileOutputStream(selectedFile);
					
						model.performingOperation(getString("op.export.writer",selectedFile.getName()));
						writer
							= new PrintWriter(os);
					
						int x = 0;
						for (JournalEntry entry : entries) 
						{
							model.performingOperation(getString("op.export.write",selectedFile.getName(),(++x)));
							writer.println(
								sdf.format(entry.getDay().getTime())
							);
							writer.println(
								entry.getJournal().getName()
							);
							writer.println(
								entry.getSubject()
							);
							writer.println(
								entry.getEntry()
							);
							writer.println("");
							writer.println("");
						}
					
						writer.flush();
						writer.close();
						writer = null;
						
						os.close();
						os = null;
						
						model.performingOperation(getString("op.export.write.success",selectedFile.getName()));
					}
					catch (Exception e) {
						model.performingOperation(getString("op.export.write.fail",selectedFile.getName()));
						new ThrowableDialog(e,false).setVisible(true);
					}
					finally {
						try {if (writer!=null) writer.close();}catch(Exception ignore){}
						try {if (os != null) os.close();}catch(Exception ignore){}
					}
				}
				ContainerTools.setEnabled(
					  view.getJContentPane()
					, true
				);
				JComponentTools.setDefaultCursor(
					view.getJContentPane()
				);
			}
		}.start();
		
	}
	
}
