package org.ferris.journal.gui.data;

import static org.ferris.journal.gui.i18n.i18n.getString;

import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;

import javax.xml.rpc.ServiceException;

import org.apache.axis.client.Stub;
import org.ferris.journal.jws.account.Account;
import org.ferris.journal.jws.account.AccountJws;
import org.ferris.journal.jws.account.AccountJwsServiceLocator;

public class AccountDataByAxis extends AccountData 
{	
	private final String $urlstr = DataByAxis.HOST_AND_CONTEXT + "account.jws";
	private URL $url;
	private URL getUrl() {
		if ($url == null) 
		{
			try {
				$url = new URL($urlstr);
			}
			catch (MalformedURLException e) {
				throw new RuntimeException(
					getString("exception.malformed.url", $urlstr)
				);
			}
		}
		return $url;
	}
	
	public String test(String echoMeBack) 
	{
		AccountJwsServiceLocator loc
			= new AccountJwsServiceLocator();
	
		AccountJws jws = null;
		try {
			jws = loc.getAccountJwsPort(getUrl());
			setCredentials((Stub)jws);
		} catch (ServiceException e) {
			throw new RuntimeException(e);
		}
		
		try {
			return jws.test(echoMeBack);	
		} catch (RemoteException e) {
			throw new RuntimeException(e);
		}
	}
	
	public Account register(Account newAccount) 
	{
		AccountJwsServiceLocator loc
			= new AccountJwsServiceLocator();
	
		AccountJws jws = null;
		try {
			jws = loc.getAccountJwsPort(getUrl());
			setCredentials((Stub)jws);
		} catch (ServiceException e) {
			throw new RuntimeException(e);
		}
		
		try {
			return jws.register(newAccount);	
		} catch (RemoteException e) {
			throw new RuntimeException(e);
		}
	}
	
	public Account login(Account existingAccount) 
	{
		AccountJwsServiceLocator loc
			= new AccountJwsServiceLocator();
	
		AccountJws jws = null;
		try {
			jws = loc.getAccountJwsPort(getUrl());
			setCredentials((Stub)jws);
		} catch (ServiceException e) {
			throw new RuntimeException(e);
		}
		
		try {
			return jws.login(existingAccount.getUsername(), existingAccount.getPassword());	
		} catch (RemoteException e) {
			throw new RuntimeException(e);
		}
	}

}
