package org.ferris.journal.gui.data;

import org.apache.axis.AxisProperties;
import org.apache.axis.client.Stub;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.ferris.crypto.Blowfish;
import org.ferris.journal.gui.crypto.KeyMaterialLocatorForBlowfish;

public class DataByAxis
{
	public static final String HOST_AND_CONTEXT = "https://ferris.dnsalias.net/journal-jws/bin/";
        //public static final String HOST_AND_CONTEXT = "https://localhost/journal-jws/bin/";
	private Logger log = Logger.getLogger(getClass());
	
	static {
		AxisProperties.setProperty(
			 "org.apache.axis.components.net.SecureSocketFactory"
			,"org.ferris.axis.components.net.MySecureSocketFactory"
		);
	}
	
	protected void setCredentials(Stub stub) 
	{
		log.info(String.format("Enter: setCredentials(%s)", stub.toString()));
		
		log.info("Create Blowfish");
		Blowfish blowfish
			= new Blowfish(
				new KeyMaterialLocatorForBlowfish()
			);
		
		
		log.info("Decode username");
		stub.setUsername(
		 	blowfish.decrypt(
		 		Base64.decodeBase64(
		 			"sKG3NZWIK4WPaxfH9eL+cg==".getBytes()
		 		)
		 	)
		);

		log.info("Decode password");
		stub.setPassword(
		 	blowfish.decrypt(
		 		Base64.decodeBase64(
		 			"XknuwCFDd6vqipNwTZVk4RFvC2uKDFtd".getBytes()
		 		)
		 	)
		);
	}
}
