package org.ferris.journal.gui.data;

import java.util.List;

import org.ferris.journal.jws.account.Account;
import org.ferris.journal.jws.journal.Journal;



public abstract class JournalData extends DataByAxis
{
	private static JournalData instance;
	public static final JournalData getInstance() {
		if (instance == null) {
			instance = new JournalDataByAxis();
		}
		return instance;
	}
	
	public abstract List<Journal> findAll(Account account);
	
	public abstract Journal insert(Journal account);	
	public abstract Journal update(Journal account);	
	
	public abstract Journal find(Account account, long journalId);
	
	public abstract Boolean delete(Account account, long journalId);
	
}
