package org.ferris.journal.gui.data;

import static org.ferris.journal.gui.i18n.i18n.getString;

import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.xml.rpc.ServiceException;

import org.apache.axis.client.Stub;
import org.ferris.journal.jws.account.Account;
import org.ferris.journal.jws.journal.Journal;
import org.ferris.journal.jws.journal.JournalJws;
import org.ferris.journal.jws.journal.JournalJwsServiceLocator;

public class JournalDataByAxis extends JournalData 
{	
	private final String $urlstr = DataByAxis.HOST_AND_CONTEXT + "journal.jws";
	private URL $url;
	private URL getUrl() {
		if ($url == null) 
		{
			try {
				$url = new URL($urlstr);
			}
			catch (MalformedURLException e) {
				throw new RuntimeException(
					getString("exception.malformed.url", $urlstr)
				);
			}
		}
		return $url;
	}
	
	
	private JournalJws getJws() {
		JournalJwsServiceLocator loc
		= new JournalJwsServiceLocator();

		JournalJws jws = null;
		try {			
			jws = loc.getJournalJwsPort(getUrl());
			setCredentials((Stub)jws);
		} catch (ServiceException e) {
			throw new RuntimeException(e);
		}
		return jws;
	}
	
	public String test(String echoMeBack) 
	{
		try {			
			return getJws().test(echoMeBack);	
		} catch (RemoteException e) {
			throw new RuntimeException(e);
		}
	}
	@Override
	public List<Journal> findAll(Account account)
	{
		try {
			Journal [] js = getJws().findAll(account);
			return (js == null) ? new ArrayList<Journal>() : Arrays.asList(js);	
		} catch (RemoteException e) {
			throw new RuntimeException(e);
		}
	}
	@Override
	public Journal insert(Journal account)
	{
		try {
			return getJws().insert(account);			
		} catch (RemoteException e) {
			throw new RuntimeException(e);
		}
	}
	@Override
	public Journal update(Journal account)
	{
		try {
			return getJws().update(account);			
		} catch (RemoteException e) {
			throw new RuntimeException(e);
		}
	}
	@Override
	public Journal find(Account account, long journalId) 
	{
		try {
			return getJws().findById(account, journalId);			
		} catch (RemoteException e) {
			throw new RuntimeException(e);
		}
	}
	@Override
	public Boolean delete(Account account, long journalId) 
	{
		try {
			return getJws().delete(account, journalId);			
		} catch (RemoteException e) {
			throw new RuntimeException(e);
		}
	}
}
