package org.ferris.journal.gui.data;

import java.util.Calendar;
import java.util.List;

import org.ferris.journal.jws.journalentry.JournalEntry;



public abstract class JournalEntryData extends DataByAxis
{
	private static JournalEntryData instance;
	public static final JournalEntryData getInstance() {
		if (instance == null) {
			instance = new JournalEntryDataByAxis();
		}
		return instance;
	}
	
	public abstract JournalEntry insert(JournalEntry entry);	
	public abstract JournalEntry update(JournalEntry entry);	
	
	public abstract List<JournalEntry> search(long accountId, String keyword, long[] journalIds, Calendar minInclusive, Calendar maxInclusive);
	
	public abstract Boolean delete(long accountIdaccount, long journalEntryId);
	
}
