package org.ferris.journal.gui.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;

import org.ferris.journal.jws.journal.Journal;

public class JournalList 
{
	
	private List<Journal> getAll() {
		if (all == null) {
			all = new ArrayList<Journal>();
		}
		return all;
	}
		
	private List<Journal> getActive() {
		if (active == null) {
			active = new ArrayList<Journal>() {
				private static final long serialVersionUID = -2438861478410307586L;
				public boolean add(Journal j) {
					if (j.getIsActive()) {
						super.add(j);
						return true;
					} else {
						return false;
					}
				}
			};
		}
		return active;
	}
	
	
	
	private List<Journal> all 
		= null;	
	private List<Journal> active 
		= null;
	private Comparator<Journal> journalNameComparator
		= new JournalNameComparator();	
	
		

	public List<Journal> all() {
		//return (all == null) ? null : Collections.unmodifiableList(all);	
		return Collections.unmodifiableList(getAll());
	}	
	
	public List<Journal> active() {
		//return (active == null) ? null : Collections.unmodifiableList(active);
		return Collections.unmodifiableList(getActive());
	}
	
	public void add(List<Journal> journals) 
	{
		if (journals == null) { return; }		
		for (Journal journal : journals) 
		{			
			add(journal);
		}
	}
	
	public void add(Journal journal) {
		if (getAll().add(journal)) {
			Collections.sort(getAll(), journalNameComparator);
		}
		
		if (getActive().add(journal)) {
			Collections.sort(getActive(), journalNameComparator);
		}
	}
	
	public void remove(Journal journal) 
	{
		for (ListIterator<Journal> itr=getAll().listIterator(); itr.hasNext();) {
			if (itr.next().getId().equals(journal.getId())) {
				itr.remove();
				break;
			}
		}
		for (ListIterator<Journal> itr=getActive().listIterator(); itr.hasNext();) {
			if (itr.next().getId().equals(journal.getId())) {
				itr.remove();
				break;
			}
		}
	}

	public void update(Journal journal) 
	{
		remove(journal);
		add(journal);
	}
}
 