package org.ferris.journal.gui.model;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

import org.apache.log4j.Logger;
import org.ferris.journal.jws.account.Account;
import org.ferris.journal.jws.journal.Journal;
import org.ferris.journal.jws.journalentry.JournalEntry;

public class ModelForApplication implements Model 
{
	private Logger log 
		= Logger.getLogger(getClass());
	
	private Set<ReleaseObserver> releaseObservers 
		= Collections.synchronizedSet(new LinkedHashSet<ReleaseObserver>());

	private Set<OperationObserver> operationObservers 
		= Collections.synchronizedSet(new LinkedHashSet<OperationObserver>());

	private Set<JournalObserver> journalObservers 
		= Collections.synchronizedSet(new LinkedHashSet<JournalObserver>());
	
	private Set<JournalEntryObserver> journalEntryObservers 
		= Collections.synchronizedSet(new LinkedHashSet<JournalEntryObserver>());
	
	private Set<JournalEntrySearchObserver> journalEntrySearchObservers 
		= Collections.synchronizedSet(new LinkedHashSet<JournalEntrySearchObserver>());
	
	private Account account
		= null;
	
	private JournalList journalList
		= new JournalList();
	
	
/////////////////////////////////////////////////////////////////////
//
//	 Model Operations
//
////////////////////////////////////////////////////////////////////	/	
	public Model performingOperation(String description) {
		for (OperationObserver o : operationObservers) {
			o.performingOperation(description);
		}
		return this;
	}
	
	public Model release() {
		for (ReleaseObserver r : releaseObservers) {
			r.released();
		}
		System.exit(0);
		return this;
	}
	
	public Account getAccount() {
		return account;
	}
	
	public Model setAccount(Account iAmLoggedIn) {
		this.account = iAmLoggedIn;
		return this;
	}
		
	public List<Journal> getAllJournals() {	
		return journalList.all();
	}
	
	public Model setJournals(List<Journal> allJournals) {
		journalList.add(allJournals);			
		return this;
	}
	
	public Model insertJournal(Journal j) 
	{
		journalList.add(j);
		
		for (JournalObserver o : journalObservers) {
			o.insertedJournal(j);
		}
		
		return this;
	}
	
	public Model updateJournal(Journal j)
	{
		journalList.update(j);
		
		for (JournalObserver o : journalObservers) {
			o.updatedJournal(j);
		}
		
		return this;
	}
	
	
	public Model newJournal()
	{
		for (JournalObserver o : journalObservers) {
			o.newJournal();
		}
		return this;
	}
	
	
	public Model editJournal(Journal editMe)
	{
		for (JournalObserver o : journalObservers) {
			o.editJournal(editMe);
		}
		return this;
	}
	
	
	public Model editJournalEntry(JournalEntry editMe)
	{
		for (JournalEntryObserver o : journalEntryObservers) {
			o.editJournalEntry(editMe);
		}
		return this;
	}
	
	
	public Model deleteJournal(Journal j)
	{
		journalList.remove(j);
		
		for (JournalObserver o : journalObservers) {
			o.deletedJournal(j);
		}
		
		return this;
	}
	

	public List<Journal> getActiveJournals() {
		return journalList.active();
	}
	
	
	public Model insertJournalEntry(JournalEntry je) 
	{
		for (JournalEntryObserver o : journalEntryObservers) {
			o.insertedJournalEntry(je);
		}
		
		return this;
	}
	
	
	public Model updateJournalEntry(JournalEntry je) 
	{
		for (JournalEntryObserver o : journalEntryObservers) {
			o.updatedJournalEntry(je);
		}
		
		return this;
	}
	
	public Model newJournalEntry() {
		for (JournalEntryObserver o : journalEntryObservers) {
			o.newJournalEntry();
		}
		return this;
	}
	
	
	public Model deleteJournalEntry(JournalEntry j)
	{
		for (JournalEntryObserver o : journalEntryObservers) {
			o.deletedJournalEntry(j);
		}
		
		return this;
	}
	
	
	public Model setJournalEntrySearchResults(List<JournalEntry> searchResults) 
	{
		for (JournalEntrySearchObserver o : journalEntrySearchObservers) {
			o.results(searchResults);
		}
		
		return this;
	}
	
	
	

	
/////////////////////////////////////////////////////////////////////
//
// Observers
//
/////////////////////////////////////////////////////////////////////
	public Model registerObserver(ReleaseObserver observer) {
		log.info("Register : ReleaseObserver : " + observer.hashCode());
		releaseObservers.add(observer);
		return this;
	}	
	public ReleaseObserver removeObserver(ReleaseObserver observer) {
		log.info("Remove : ReleaseObserver : " + observer.hashCode());
		return releaseObservers.remove(observer) ? observer : null;
	}

	
	public Model registerObserver(OperationObserver observer) {
		log.info("Register : OperationObserver : " + observer.hashCode());
		operationObservers.add(observer);
		return this;
	}	
	public OperationObserver removeObserver(OperationObserver observer) {	
		log.info("Remove : OperationObserver : " + observer.hashCode());
		return operationObservers.remove(observer) ? observer : null;
	}
	
	
	public Model registerObserver(JournalObserver observer) {
		log.info("Register : JournalObserver : " + observer.hashCode());
		journalObservers.add(observer);
		return this;
	}	
	public JournalObserver removeObserver(JournalObserver observer) {	
		log.info("Remove : JournalObserver : " + observer.hashCode());
		return journalObservers.remove(observer) ? observer : null;
	}
	
	
	public Model registerObserver(JournalEntryObserver observer) {
		log.info("Register : JournalEntryObserver : " + observer.hashCode());
		journalEntryObservers.add(observer);
		return this;
	}	
	public JournalEntryObserver removeObserver(JournalEntryObserver observer) {	
		log.info("Remove : JournalEntryObserver : " + observer.hashCode());
		return journalEntryObservers.remove(observer) ? observer : null;
	}

	public Model registerObserver(JournalEntrySearchObserver observer) {
		log.info("Register : JournalEntrySearchObserver : " + observer.hashCode());
		journalEntrySearchObservers.add(observer);
		return this;
	}

	public JournalEntrySearchObserver removeObserver(JournalEntrySearchObserver observer) {
		log.info("Remove : JournalEntrySearchObserver : " + observer.hashCode());
		return journalEntrySearchObservers.remove(observer) ? observer : null;
	}

}
