package org.ferris.journal.gui.view.button;

import static org.ferris.journal.gui.i18n.i18n.getString;

import javax.swing.JButton;

import org.apache.log4j.Logger;

public class KButton extends JButton
{
	private static final long serialVersionUID = 28116360421413325L;
	private Logger log = Logger.getLogger(getClass());
	private Boolean setEnabledStackTrace = false;
	
	
	protected KButton(String i18nKey, String actionCommand)
	{
		super();
		setText(getString(i18nKey));
		setActionCommand(actionCommand);
	}
		
	
	public void setEnabledStackTrace(Boolean b) {
		setEnabledStackTrace = b;
	}
	
	@Override
	public void setEnabled(boolean b)
	{
		if (setEnabledStackTrace) {
			Exception e = new Exception();
			StackTraceElement [] eles = e.getStackTrace();
			if (eles != null) {
				for (int i=0; i<eles.length && i<=3; i++) {
					String s1 = eles[i].getClassName();
					String s2 = eles[i].getMethodName();
					int    i1 = eles[i].getLineNumber();
					log.info(s1 + "." + s2 + "("+b+") LINE: " + i1);
				}
			}
		}
		
		super.setEnabled(b);
	}	
}
