package org.ferris.journal.gui.view.editorpane;

import java.awt.Color;
import java.util.List;

import javax.swing.JTextPane;

import org.apache.commons.lang.StringUtils;
import org.ferris.constraint.Check;
import org.ferris.constraint.Constraint;

public abstract class KAbstractTextPane extends JTextPane 
{
	private static final long serialVersionUID = 5471978378975677103L;
	
	private Color originalBackgroundColor;
	
	public KAbstractTextPane() {
		super();
		originalBackgroundColor = getBackground();
	}
	
	public abstract Constraint<String> getConstraint(); 
	
	public abstract String getExplaination(Check check); 
	
	public KAbstractTextPane validate(List<String> explainations) 
	{
		setBackground(originalBackgroundColor);
		
		setText(StringUtils.trimToEmpty(getText()));
	
		Check check 
			= getConstraint().check(getText());
		
		if (check != null) {
			setBackground(Color.red);
			explainations.add(getExplaination(check));
		}
		
		return this;
	}
	
	public Color getOriginalBackgroundColor() {
		return originalBackgroundColor;
	}	

}
