package org.ferris.journal.gui.view.images;

import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;

import javax.swing.Icon;
import javax.swing.ImageIcon;

import org.apache.log4j.Logger;

public class ImageFactory
{
	private static Logger log = Logger.getLogger(ImageFactory.class);
	
	private static String packageName;
	private static String getPackageName() 
	{
		log.info(String.format("ENTER: getPackageName()"));
		if (packageName == null) {
//			packageName 
//				= ImageFactory.class.getPackage().getName();
//		
//			packageName
//				= '/' + packageName.replace('.', '/') + '/';
			packageName = "/";
		}
		log.info(String.format("packageName=\"%s\"",packageName));
		return packageName;
	}
	
	private static Image getImage(String imageName) {
		log.info(String.format("ENTER: getImage(\"%s\")",imageName));
		return 
			Toolkit
			.getDefaultToolkit()
			.createImage(
				ImageFactory
					.class
					.getResource(getPackageName() + imageName)
			);
	}
	
	private static Icon getIcon(String imageName) 
	{
		log.info(String.format("ENTER: getIcon(\"%s\")",imageName));
		URL imgURL 
			= ImageFactory
				.class
				.getResource(getPackageName() + imageName);
		log.info(String.format("imgURL=",String.valueOf(imgURL)));
	    return new ImageIcon(imgURL);
	}
	
	private static Image applicationIcon;
	public static Image getApplicationIcon()
	{
		log.info(String.format("ENTER: getApplicationIcon()"));
		if (applicationIcon == null) {
			applicationIcon = getImage("FerrisPencilIcon.gif"); 
		}
		return applicationIcon;
	}
	
	private static Icon textFileIcon;
	public static Icon getTextFileIcon() 
	{
		log.info(String.format("ENTER: getTextFileIcon()"));
		if (textFileIcon == null) {
			textFileIcon = getIcon("FerrisTextfileIcon.gif");
		}
		return textFileIcon;
	}
}
