package org.ferris.journal.gui.view.list;

import java.util.ArrayList;
import java.util.List;

import javax.swing.JList;
import javax.swing.SwingUtilities;

import org.apache.log4j.Logger;
import org.ferris.journal.jws.journal.Journal;

public class KJournalList extends JList {

	private Logger log = Logger.getLogger(getClass());
	
	private static final long serialVersionUID = -6949799304095333307L;
	
	public KJournalList(KAbstractJournalListModel m) {
		super(m);
		setCellRenderer(new KJournalListCellRenderer());
	}
	
	public KAbstractJournalListModel getJournalListModel() {
		log.info("ENTER: getJournalListModel()");
		return (KAbstractJournalListModel)getModel();
	}
	
	public List<Journal> getSelectedJournals()
	{
		Object [] array
			= getSelectedValues();
		
		int lngth = (array == null) ? 0 : array.length;
		
		List<Journal> selected
			= new ArrayList<Journal>(lngth);
		
		for (int i=0; i<lngth; i++) {
			selected.add((Journal)array[i]);
		}
		
		return selected;
	}

	@Override
	public void setSelectedValue(Object anObject,boolean shouldScroll) 
	{
		log.info("ENTER: setSelectedValue()");
		
        if(anObject == null) {
        	log.info("The parameter anObject == null");
            setSelectedIndex(-1);
        }    
        else
        if (! Journal.class.isAssignableFrom(anObject.getClass())) {
        	log.info("The parameter's anObject class is \""+anObject.getClass()+"\" which is not assignable to \""+Journal.class+"\" ");
        	super.setSelectedValue(anObject, shouldScroll);
        }
        else 
        {
        	KAbstractJournalListModel listModel
        		= getJournalListModel();
        	
        	Journal newSelectedJournal 
        		= (Journal)anObject;
        	
        	final int newSelectedIndex =
        		listModel.getIndexOf(newSelectedJournal);
        	log.info("newSelectedIndex: " + newSelectedIndex);
        	
        	//if (newSelectedIndex != getSelectedIndex()) {
        		SwingUtilities.invokeLater(
					new Runnable() {
						public void run()
						{
							log.info("ENTER: run()");
							log.info("Set selected index to: " + newSelectedIndex);
			        		setSelectedIndex(newSelectedIndex);
		        			ensureIndexIsVisible(newSelectedIndex);
		        			fireSelectionValueChanged(newSelectedIndex, newSelectedIndex, false);
		        			//repaint();
		        			log.info("EXIT: run()");
						}
					}
				);
        	//}
        }
        log.info("EXIT: setSelectedValue()");
    }
}
