package org.ferris.journal.gui.view.panel;

import static org.ferris.journal.gui.i18n.i18n.getString;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import java.util.prefs.Preferences;

import javax.swing.JLabel;
import javax.swing.JPanel;

import org.ferris.journal.gui.view.textfield.KEmailTextField;
import org.ferris.journal.gui.view.textfield.KPasswordField;

public class KCredentialsPanel extends JPanel 
{
	private static final long serialVersionUID = 129070928409872L;
	private JLabel emailLabel = null;	
	private JLabel passwordLabel = null;	
	
	private KEmailTextField emailText = null;	
	private KPasswordField passwordText = null;
	
	private Preferences prefs =  null; //  @jve:decl-index=0:

	/**
	 * This is the default constructor
	 */
	public KCredentialsPanel() {
		super();
		initialize();
	}

	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	private void initialize() {
		prefs = Preferences.userNodeForPackage(this.getClass());
		
		Runtime.getRuntime().addShutdownHook(
			new Thread() {
				public void run() {
					try {
						prefs.put("email", getEmailText().getText());
						prefs.flush();
					}catch (Throwable ignore){} 
				}
			}
		);
		
		GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
		gridBagConstraints3.fill = GridBagConstraints.HORIZONTAL;
		gridBagConstraints3.gridy = 1;
		gridBagConstraints3.weightx = 1.0;
		gridBagConstraints3.insets = new Insets(0, 5, 0, 5);
		gridBagConstraints3.gridx = 1;
		GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
		gridBagConstraints2.fill = GridBagConstraints.HORIZONTAL;
		gridBagConstraints2.gridy = 0;
		gridBagConstraints2.weightx = 1.0;
		gridBagConstraints2.insets = new Insets(0, 5, 0, 5);
		gridBagConstraints2.gridx = 1;
		GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
		gridBagConstraints1.gridx = 0;
		gridBagConstraints1.anchor = GridBagConstraints.EAST;
		gridBagConstraints1.insets = new Insets(8, 5, 8, 5);
		gridBagConstraints1.fill = GridBagConstraints.NONE;
		gridBagConstraints1.gridy = 1;
		passwordLabel = new JLabel();
		passwordLabel.setText(getString("label.password"));
		GridBagConstraints gridBagConstraints = new GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.anchor = GridBagConstraints.EAST;
		gridBagConstraints.insets = new Insets(8, 5, 8, 5);
		gridBagConstraints.fill = GridBagConstraints.NONE;
		gridBagConstraints.gridy = 0;
		emailLabel = new JLabel();
		emailLabel.setText(getString("label.username"));
		this.setSize(300, 67);
		this.setLayout(new GridBagLayout());
		this.add(emailLabel, gridBagConstraints);
		this.add(passwordLabel, gridBagConstraints1);
		this.add(getEmailText(), gridBagConstraints2);
		this.add(getPasswordText(), gridBagConstraints3);
	}
	

	/**
	 * This method initializes emailText	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private KEmailTextField getEmailText() {
		if (emailText == null) {
			emailText = new KEmailTextField();
			emailText.setText(prefs.get("email", ""));
		}
		return emailText;
	}

	/**
	 * This method initializes passwordText	
	 * 	
	 * @return javax.swing.JPasswordField	
	 */
	private KPasswordField getPasswordText() {
		if (passwordText == null) {
			passwordText = new KPasswordField();
		}
		return passwordText;
	}
	
	public void focusOnPassword() {
		getPasswordText().grabFocus();
	}

	public void validate(List<String> explainations)
	{		
		getEmailText().validate(explainations);
		getPasswordText().validate(explainations);
	}

	public String getUsername() {
		return getEmailText().getText();
	}
	
	public char[] getPassword() {
		return getPasswordText().getPassword();
	}
	
}  //  @jve:decl-index=0:visual-constraint="10,10"
