package org.ferris.journal.gui.view.table;

import java.lang.reflect.Method;
import java.util.List;

import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;

import org.apache.log4j.Logger;
import org.ferris.journal.jws.journalentry.JournalEntry;

public class KEntryTable extends JTable 
{
	private Logger log = Logger.getLogger(getClass());
	
	private static final long serialVersionUID = 1826009857640983576L;

	public KEntryTable(KEntryTableModel dm) {
		super(dm);
		setSelectionMode(ListSelectionModel.SINGLE_SELECTION);	
		
		try {
			String ver = System.getProperty("java.vm.version");
			log.info("Version: " + ver);
			ver = ver.substring(0,3);
			log.info("Version: " + ver);
			double d = Double.parseDouble(ver);
			log.info("Version: " + d);
			if (d >= 1.6) {
				Method m =
					getClass().getMethod("setAutoCreateRowSorter", new Class[]{boolean.class});
				m.invoke(this, new Object[]{true});
			}
		} catch (Exception ignore) {
			log.error("oops", ignore);
		}
	}
	
	
	public KEntryTableModel getEntryTableModel() 
	{
		return (KEntryTableModel)getModel();
	}
	
	public KEntryTable setEntries(List<JournalEntry> entries)
	{
		getEntryTableModel().setEntries(entries);
		return this;
	}


	public JournalEntry getSelectedEntry() 
	{
		int i = getSelectedRow();
		JournalEntry retval = null;
		if (i >= 0) {
			retval = getEntryTableModel().getEntries().get(i);
		}
		return retval;
	}


	public void deleteEntry(JournalEntry deletedJournal) 
	{
		int idx = getSelectedRow();
		int u = getEntryTableModel().deleteEntry(deletedJournal);
		if (u != -1 && idx != -1) {
			if (idx >= getEntryTableModel().getEntries().size()) {
				idx = getEntryTableModel().getEntries().size() - 1;
			}
			addRowSelectionInterval(idx, idx);
		}
		
	}


	public void addEntry(JournalEntry newJournal) 
	{
		int idx = getSelectedRow();
		int u = getEntryTableModel().addEntry(newJournal);
		if (u != -1 && idx != -1 && idx < u) {
			addRowSelectionInterval(idx, idx);
		}
	}


	public void updateEntry(JournalEntry updatedJournal) 
	{
		int idx = getSelectedRow();
		int u = getEntryTableModel().updateEntry(updatedJournal);
		if (u != -1 && idx != -1 && idx < getEntryTableModel().getEntries().size()) {
			addRowSelectionInterval(idx, idx);
		}
	}
	
	int x = 0;
	
	@Override	
	public void valueChanged(ListSelectionEvent e) {
		super.valueChanged(e);
		if (!e.getValueIsAdjusting()) {
			System.out.println("************* "+(++x)+" : " + getSelectedRow());
		}
		
	}
}
